/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
package blanco.commons.util;

import java.io.UnsupportedEncodingException;

/**
 * blanco FrameworkɂAɊւ郆[eBeB̓܂܂܂B
 * 
 * ̃NX̓pbP[WOJƐݒ肵Ă܂B
 * 
 * @author IGA Tosiki
 */
class BlancoStringUtilPad {
    /**
     * w̒ɂȂ܂ŁẢEɕǉ܂B
     * 
     * @param argSource
     *            IWiB
     * @param argLength
     *            ]钷B
     * @param argPadChar
     *            lߍ݂ɗp镶B
     * @return w̒ɉH̕Bw̒IWi񂪒ꍇɂ́AIWi񂪂̂܂ܖ߂܂B
     */
    public static final String padRight(final String argSource,
            final int argLength, final char argPadChar) {
        if (argSource == null) {
            throw new IllegalArgumentException(
                    "BlancoStringUtil.padRight͕̓null^܂B");
        }

        final StringBuffer buf = new StringBuffer();
        buf.append(argSource);

        for (; buf.length() < argLength;) {
            // ꕶ₵Ă܂B
            buf.append(argPadChar);
        }

        return buf.toString();
    }

    /**
     * w̒ɂȂ܂ŁA̍ɕǉ܂B
     * 
     * @param argSource
     *            IWiB
     * @param argLength
     *            ]钷B
     * @param argPadChar
     *            lߍ݂ɗp镶B
     * @return w̒ɉH̕Bw̒IWi񂪒ꍇɂ́AIWi񂪂̂܂ܖ߂܂B
     */
    public static final String padLeft(final String argSource,
            final int argLength, final char argPadChar) {
        if (argSource == null) {
            throw new IllegalArgumentException(
                    "BlancoStringUtil.padLefo͕̓null^܂B");
        }

        final int originalLength = argSource.length();
        final StringBuffer buf = new StringBuffer();

        for (; buf.length() + originalLength < argLength;) {
            // ꕶ₵Ă܂B
            buf.append(argPadChar);
        }

        return buf.toString() + argSource;
    }

    /**
     * Windows-31J ZŎw̒ɂȂ܂ŁẢEɕǉ܂B
     * 
     * @param argSource
     *            IWiB
     * @param argLength
     *            ]钷B
     * @param argPadChar
     *            lߍ݂ɗp镶B
     * @return w̒ɉH̕Bw̒IWi񂪒ꍇɂ́AIWi񂪂̂܂ܖ߂܂B
     */
    public static final String padRightWindows31J(final String argSource,
            final int argLength, final char argPadChar) {
        if (argSource == null) {
            throw new IllegalArgumentException(
                    "BlancoStringUtil.padRight͕̓null^܂B");
        }

        final StringBuffer buf = new StringBuffer();
        buf.append(argSource);

        try {
            for (; buf.toString().getBytes("Windows-31J").length < argLength;) {
                // ꕶ₵Ă܂B
                buf.append(argPadChar);
            }
            return buf.toString();
        } catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(
                    "z肵ȂO܂BWindows-31J GR[fBO擾ł܂łB", ex);
        }
    }

    /**
     * Windows-31J ZŎw̒ɂȂ܂ŁA̍ɕǉ܂B
     * 
     * @param argSource
     *            IWiB
     * @param argLength
     *            ]钷B
     * @param argPadChar
     *            lߍ݂ɗp镶B
     * @return w̒ɉH̕Bw̒IWi񂪒ꍇɂ́AIWi񂪂̂܂ܖ߂܂B
     */
    public static final String padLeftWindows31J(final String argSource,
            final int argLength, final char argPadChar) {
        if (argSource == null) {
            throw new IllegalArgumentException(
                    "BlancoStringUtil.padLefo͕̓null^܂B");
        }

        try {
            final int originalLength = argSource.getBytes("Windows-31J").length;
            final StringBuffer buf = new StringBuffer();

            for (; buf.toString().getBytes("Windows-31J").length
                    + originalLength < argLength;) {
                // ꕶ₵Ă܂B
                buf.append(argPadChar);
            }
            return buf.toString() + argSource;
        } catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(
                    "z肵ȂO܂BWindows-31J GR[fBO擾ł܂łB", ex);
        }
    }
}
