/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.jsf.task.valueobject.BlancoJsfProcessInput;
import blanco.jsf.valueobject.BlancoJsfStructure;

public class BlancoJsfXml2ConfigFile {
    public void structure2Xml(final List<BlancoJsfStructure> structureList,
            final BlancoJsfProcessInput input) throws IOException {
        final File directoryTargetXml = new File(input.getTargetdirxml());
        if (directoryTargetXml.exists() == false) {
            if (directoryTargetXml.mkdirs() == false) {
                throw new IllegalArgumentException("XMLi[fBNg[ ["
                        + directoryTargetXml.getAbsolutePath()
                        + "] ̍쐬Ɏs܂B");
            }
        }

        new BlancoJsfExpandFacesConfig().expandXmlFile(structureList, input);
    }
}
