/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.csv.resourcebundle.BlancoCsvIOExceptionDotNetResourceBundle;
import blanco.csv.valueobject.BlancoCsvStructureDotNet;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.method.IgConstructor;

public class BlancoCsvExpandIOExceptionDotNet {
    private final BlancoCsvIOExceptionDotNetResourceBundle bundle = new BlancoCsvIOExceptionDotNetResourceBundle();

    public void expand(final BlancoCsvStructureDotNet processStructure,
            final File directoryTarget) {

        final String packageName = processStructure.getRuntimePackage()
                + bundle.getPackagePrefix();
        final ClassExpander classExpander = new ClassExpander(new IgType(
                packageName, bundle.getClassName())) {
            protected void expandClassStruct() {
                setSuperClass(new IgType(bundle.getSuperclassName()));
                addFileComment(bundle.getFilecomment());

                getJavaDoc().addLine(bundle.getClasscomment01());
                getJavaDoc().addLine(bundle.getClasscomment02());

                addMethod(new IgConstructor(bundle.getClassName()) {
                    public void setupSignature() {
                        getJavaDoc().addLine(bundle.getConstructor01Comment());

                        // qݒB
                        getCgMethod().setSuperclassInvocation("base(message)");

                        getJavaDoc().addLine(
                                bundle.getConstructor01Arg01Comment());
                        addArgument(new IgValue(new IgType(bundle
                                .getConstructor01Arg01Type()), "message"));
                    }

                    public void implement() {
                    }
                });

                // C#.NETŌŗL̋@\B
                addMethod(new IgConstructor(bundle.getClassName()) {
                    public void setupSignature() {
                        getJavaDoc().addLine(bundle.getConstructor01Comment());

                        // qݒB
                        getCgMethod().setSuperclassInvocation(
                                "base(" + "message" + ", innerException)");

                        getJavaDoc().addParameter("message",
                                bundle.getConstructor01Arg01Comment());
                        getJavaDoc().addParameter("innerException",
                                "Ƃ̗OIuWFNgB");
                        addArgument(new IgValue(new IgType(bundle
                                .getConstructor01Arg01Type()), "message"));
                        addArgument(new IgValue(new IgType("System.Exception"),
                                "innerException"));
                    }

                    public void implement() {
                    }
                });
            }
        };

        ClassExpander.generateCsSource(classExpander, directoryTarget);
    }
}
