/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle;

import java.io.File;

import blanco.resourcebundle.expand.BlancoResourceBundleExpandResourceBundle;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;

/**
 * XMLt@C vpeBt@CANZXpJava\[XR[h𐶐܂B
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXml2JavaClass {
    /**
     * \[XohMessageFormatɂp[XsۂɁAO珈𒆒f邩ǂ̃tOB
     * 
     * trueȂ珈fėO𔭐܂B<br>
     * falseȂ珈sAû͖Ƃ݂Ȃ܂B<br>
     * Javã\[XR[hۂȂǂɁA falseɐݒ肵ĔgʂƂł悤ɐ؂ւꍇ܂B<br>
     * ftHgl[true]ݒ肳Ă܂B
     */
    private boolean fIsFailOnMessageFormatError = true;

    /**
     * Oo͂\[XR[hɊ܂߂邩ǂ̃tOB݂͕Wo݂͂̂ɑΉB
     */
    private boolean fIsLog = false;

    /**
     * vpeBt@CfBNgtŏo͂邩ǂB
     */
    private boolean fPropertieswithdirectory = true;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * \[XohMessageFormatɂp[XsۂɁAO珈𒆒f邩ǂ̃tOݒ肵܂B
     * 
     * trueȂ珈fėO𔭐܂B<br>
     * falseȂ珈sAû͖Ƃ݂Ȃ܂B<br>
     * Javã\[XR[hۂȂǂɁA falseɐݒ肵ĔgʂƂł悤ɐ؂ւꍇ܂B<br>
     * ftHgl[true]ݒ肳Ă܂B
     * 
     * @param isFailOnMessageFormatError
     */
    public void setFailOnMessageFormatError(
            final boolean isFailOnMessageFormatError) {
        fIsFailOnMessageFormatError = isFailOnMessageFormatError;
    }

    /**
     * Oo͂\[XR[hɊ܂߂邩ǂ̃tÕZbgB
     * 
     * @param argIsLog
     *            Oo͂\[XR[hɊ܂߂邩ǂB
     */
    public void setLog(final boolean argIsLog) {
        fIsLog = argIsLog;
    }

    /**
     * vpeBt@CfBNgtŏo͂邩ǂ̃tOZbg܂B
     * 
     * @param isPropertieswithdirectory
     *            vpeBt@CfBNgtŏo͂邩ǂB
     */
    public void setPropertieswithdirectory(
            final boolean isPropertieswithdirectory) {
        fPropertieswithdirectory = isPropertieswithdirectory;
    }

    /**
     * XMLt@C vpeBt@CANZXpJava\[XR[h𐶐܂B
     * 
     * @param argFileSource
     *            ͂ƂȂ钆XMLt@CB
     * @param argDirectoryTarget
     *            \[XR[ho͂ۂ̏o͐fBNgB
     */
    public void process(final File argFileSource, final File argDirectoryTarget) {
        final BlancoResourceBundleBundleStructure[] structures = new BlancoResourceBundleXmlParser()
                .parse(argFileSource);
        for (int index = 0; index < structures.length; index++) {
            structure2Source(structures[index], argDirectoryTarget);
        }
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param argStructure
     *            ^XN̍\B
     * @param argDirectoryTarget
     *            o͐fBNg
     */
    public void structure2Source(
            final BlancoResourceBundleBundleStructure argStructure,
            final File argDirectoryTarget) {
        new BlancoResourceBundleExpandResourceBundle().expand(argStructure,
                argDirectoryTarget, fEncoding, fIsFailOnMessageFormatError,
                fIsLog, fPropertieswithdirectory);
    }
}