/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf.resourcebundle;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * BlancoJsf p郊\[Xoh~܂B
 *
 * \[Xoh`: [BlancoJsf]B<BR>
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoJsfResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoJsfResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoJsf]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoJsfResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/jsf/resourcebundle/BlancoJsf");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoJsfResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoJsf]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoJsfResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/jsf/resourcebundle/BlancoJsf", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoJsfResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoJsf]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoJsfResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("blanco/jsf/resourcebundle/BlancoJsf", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoJsf], key[METAFILE_DISPLAYNAME]
     *
     * [JSF`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "JSF`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
