/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.jsf.message.BlancoJsfMessage;
import blanco.jsf.valueobject.BlancoJsfProcessBeanItemStructure;
import blanco.jsf.valueobject.BlancoJsfProcessSqlItemStructure;
import blanco.jsf.valueobject.BlancoJsfProcessStructure;
import blanco.jsf.valueobject.BlancoJsfStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * ` XML 𒊏o܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoJsfXmlParser {
    /**
     * bZ[WNXB
     */
    protected final BlancoJsfMessage fMsg = new BlancoJsfMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public List<BlancoJsfStructure> parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public List<BlancoJsfStructure> parse(final BlancoXmlDocument argXmlDocument) {
        final List<BlancoJsfStructure> structureList = new ArrayList<BlancoJsfStructure>();

        final List<BlancoJsfProcessStructure> processStructureList = new ArrayList<BlancoJsfProcessStructure>();

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List<blanco.xml.bind.valueobject.BlancoXmlElement> listSheet = BlancoXmlBindingUtil
                .getElementsByTagName(elementRoot, "sheet");

        for (int index = 0; index < listSheet.size(); index++) {
            final BlancoXmlElement elementSheet = listSheet.get(index);

            final List<blanco.xml.bind.valueobject.BlancoXmlElement> listCommon = BlancoXmlBindingUtil
                    .getElementsByTagName(elementSheet, "blancojsf-common");
            if (listCommon.size() == 0) {
                // commonꍇɂ̓XLbv܂B
                continue;
            }

            // ŏ̃ACêݏĂ܂B
            final BlancoXmlElement elementCommon = listCommon.get(0);
            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                // namȅꍇɂ͏XLbv܂B
                continue;
            }

            final BlancoJsfStructure structure = parseSheet(elementSheet,
                    elementCommon);
            if (structure != null) {
                // ꂽL܂B
                structureList.add(structure);
            }
        }

        for (int index = 0; index < listSheet.size(); index++) {
            final BlancoXmlElement elementSheet = listSheet.get(index);

            final List<blanco.xml.bind.valueobject.BlancoXmlElement> listAction = BlancoXmlBindingUtil
                    .getElementsByTagName(elementSheet,
                            "blancojsfprocess-initialize");
            if (listAction.size() == 0) {
                // commonꍇɂ̓XLbv܂B
                continue;
            }

            for (BlancoXmlElement elementCommon : listAction) {
                final String name = BlancoXmlBindingUtil.getTextContent(
                        elementCommon, "name");
                if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                    // namȅꍇɂ͏XLbv܂B
                    continue;
                }

                final BlancoJsfProcessStructure processStructure = parseProcessSheet(
                        elementSheet, elementCommon, "initialize");
                if (processStructure != null) {
                    // ꂽL܂B
                    processStructureList.add(processStructure);
                }
            }
        }

        for (int index = 0; index < listSheet.size(); index++) {
            final BlancoXmlElement elementSheet = listSheet.get(index);

            final List<blanco.xml.bind.valueobject.BlancoXmlElement> listAction = BlancoXmlBindingUtil
                    .getElementsByTagName(elementSheet, "blancojsfprocess-view");
            if (listAction.size() == 0) {
                // commonꍇɂ̓XLbv܂B
                continue;
            }

            for (BlancoXmlElement elementCommon : listAction) {
                final String name = BlancoXmlBindingUtil.getTextContent(
                        elementCommon, "name");
                if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                    // namȅꍇɂ͏XLbv܂B
                    continue;
                }

                final BlancoJsfProcessStructure processStructure = parseProcessSheet(
                        elementSheet, elementCommon, "view");
                if (processStructure != null) {
                    // ꂽL܂B
                    processStructureList.add(processStructure);
                }
            }
        }

        for (int index = 0; index < listSheet.size(); index++) {
            final BlancoXmlElement elementSheet = listSheet.get(index);

            final List<blanco.xml.bind.valueobject.BlancoXmlElement> listAction = BlancoXmlBindingUtil
                    .getElementsByTagName(elementSheet,
                            "blancojsfprocess-action");
            if (listAction.size() == 0) {
                // commonꍇɂ̓XLbv܂B
                continue;
            }

            for (BlancoXmlElement elementCommon : listAction) {
                final String name = BlancoXmlBindingUtil.getTextContent(
                        elementCommon, "name");
                if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                    // namȅꍇɂ͏XLbv܂B
                    continue;
                }
                final String method = BlancoXmlBindingUtil.getTextContent(
                        elementCommon, "method");
                if (BlancoStringUtil.null2Blank(method).trim().length() == 0) {
                    // method̏ꍇɂ͏XLbv܂B
                    continue;
                }

                final BlancoJsfProcessStructure processStructure = parseProcessSheet(
                        elementSheet, elementCommon, "action");
                if (processStructure != null) {
                    // ꂽL܂B
                    processStructureList.add(processStructure);
                }
            }
        }

        // ꂽ JSF` JSF`Ɋ蓖āB
        // |Cg: ubNɋLqĂ邱ƂOB
        for (BlancoJsfStructure structure : structureList) {
            for (BlancoJsfProcessStructure processStructure : processStructureList) {
                if (structure.getName().equals(processStructure.getName())) {
                    structure.getProcessList().add(processStructure);
                }
            }
        }
        // TODO ǂɂЂÂȂ JSF `΃G[ƂĒʒm@\KvB

        return structureList;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoJsfStructure parseSheet(
            final BlancoXmlElement argElementSheet,
            final BlancoXmlElement argElementCommon) {
        final BlancoJsfStructure structure = new BlancoJsfStructure();
        // ̓p[^擾܂B

        // V[gڍׂȏ擾܂B
        structure.setName(BlancoXmlBindingUtil.getTextContent(argElementCommon,
                "name"));
        structure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (BlancoStringUtil.null2Blank(structure.getPackage()).trim().length() == 0) {
            throw new IllegalArgumentException(fMsg.getMbjfi001(structure
                    .getName()));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "bean") != null) {
            structure.setBean(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "bean"));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            structure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "suffix") != null) {
            structure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "suffix"));
        }

        return structure;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoJsfProcessStructure parseProcessSheet(
            final BlancoXmlElement argElementSheet,
            final BlancoXmlElement argElementCommon, final String type) {
        final BlancoJsfProcessStructure processStructure = new BlancoJsfProcessStructure();
        processStructure.setType(type);
        
        // ̓p[^擾܂B

        // V[gڍׂȏ擾܂B
        processStructure.setName(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "name"));
        processStructure.setMethod(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "method"));

        if ("action".equals(type)) {
            if (BlancoStringUtil.null2Blank(processStructure.getMethod())
                    .trim().length() == 0) {
                throw new IllegalArgumentException(fMsg
                        .getMbjfi001(processStructure.getMethod()));
            }
            if ("initialize".equals(processStructure.getMethod())) {
                throw new IllegalArgumentException(fMsg
                        .getMbjfi003(processStructure.getMethod()));
            } else if ("view".equals(processStructure.getMethod())) {
                throw new IllegalArgumentException(fMsg
                        .getMbjfi004(processStructure.getMethod()));
            }
        } else {
            processStructure.setMethod(processStructure.getType());
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "forward") != null) {
            processStructure.setForward("true".equals(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "forward")));
        }

        final BlancoXmlElement elementBeanList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancojsfprocess-bean-list");

        if (elementBeanList != null) {
            // ꗗ̓e擾܂B
            final List<BlancoXmlElement> listField = BlancoXmlBindingUtil
                    .getElementsByTagName(elementBeanList, "bean");
            for (int indexField = 0; indexField < listField.size(); indexField++) {
                final BlancoXmlElement elementField = listField.get(indexField);

                final BlancoJsfProcessBeanItemStructure inputItem = new BlancoJsfProcessBeanItemStructure();

                inputItem.setName(BlancoXmlBindingUtil.getTextContent(
                        elementField, "name"));
                if (BlancoStringUtil.null2Blank(inputItem.getName()).length() == 0) {
                    continue;
                }

                processStructure.getBeanList().add(inputItem);
            }
        }

        final BlancoXmlElement elementSqlList = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancojsfprocess-sql-list");

        if (elementSqlList != null) {
            // ꗗ̓e擾܂B
            final List<BlancoXmlElement> listSqlField = BlancoXmlBindingUtil
                    .getElementsByTagName(elementSqlList, "sql");
            for (int indexField = 0; indexField < listSqlField.size(); indexField++) {
                final BlancoXmlElement elementField = listSqlField
                        .get(indexField);

                final BlancoJsfProcessSqlItemStructure inputItem = new BlancoJsfProcessSqlItemStructure();

                inputItem.setName(BlancoXmlBindingUtil.getTextContent(
                        elementField, "name"));
                if (BlancoStringUtil.null2Blank(inputItem.getName()).length() == 0) {
                    continue;
                }

                processStructure.getSqlList().add(inputItem);
            }

        }
        return processStructure;
    }
}
