/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.batchprocess.task.valueobject;

/**
 * NX [BlancoBatchProcessProcess]̓̓o[IuWFNgNXłB
 */
public class BlancoBatchProcessProcessInput {
    /**
     * verbose[hœ삳邩ǂB
     *
     * tB[h: [verbose]B
     * ftHg: [false]B
     */
    private boolean fVerbose = false;

    /**
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B
     *
     * tB[h: [metadir]B
     */
    private String fMetadir;

    /**
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B
     *
     * tB[h: [targetdir]B
     * ftHg: [blanco]B
     */
    private String fTargetdir = "blanco";

    /**
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B
     *
     * tB[h: [tmpdir]B
     * ftHg: [tmp]B
     */
    private String fTmpdir = "tmp";

    /**
     * \[Xt@C̕GR[fBOw肵܂B
     *
     * tB[h: [encoding]B
     */
    private String fEncoding;

    /**
     * ^[QbgƂȂvO~OꏈnBjava, cs, jsI\
     *
     * tB[h: [targetlang]B
     * ftHg: [java]B
     */
    private String fTargetlang = "java";

    /**
     * ^CNX𐶐鐶w肵܂Bw̏ꍇɂ `̒lɐ܂B
     *
     * tB[h: [runtimepackage]B
     */
    private String fRuntimepackage;

    /**
     * tB[h [verbose] ̒lݒ肵܂B
     *
     * tB[h̐: [verbose[hœ삳邩ǂB]B
     *
     * @param argVerbose tB[h[verbose]ɐݒ肷lB
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * tB[h [verbose] ̒l擾܂B
     *
     * tB[h̐: [verbose[hœ삳邩ǂB]B
     * ftHg: [false]B
     *
     * @return tB[h[verbose]擾lB
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * tB[h [metadir] ̒lݒ肵܂B
     *
     * tB[h̐: [^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B]B
     *
     * @param argMetadir tB[h[metadir]ɐݒ肷lB
     */
    public void setMetadir(final String argMetadir) {
        fMetadir = argMetadir;
    }

    /**
     * tB[h [metadir] ̒l擾܂B
     *
     * tB[h̐: [^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B]B
     *
     * @return tB[h[metadir]擾lB
     */
    public String getMetadir() {
        return fMetadir;
    }

    /**
     * tB[h [targetdir] ̒lݒ肵܂B
     *
     * tB[h̐: [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]B
     *
     * @param argTargetdir tB[h[targetdir]ɐݒ肷lB
     */
    public void setTargetdir(final String argTargetdir) {
        fTargetdir = argTargetdir;
    }

    /**
     * tB[h [targetdir] ̒l擾܂B
     *
     * tB[h̐: [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]B
     * ftHg: [blanco]B
     *
     * @return tB[h[targetdir]擾lB
     */
    public String getTargetdir() {
        return fTargetdir;
    }

    /**
     * tB[h [tmpdir] ̒lݒ肵܂B
     *
     * tB[h̐: [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]B
     *
     * @param argTmpdir tB[h[tmpdir]ɐݒ肷lB
     */
    public void setTmpdir(final String argTmpdir) {
        fTmpdir = argTmpdir;
    }

    /**
     * tB[h [tmpdir] ̒l擾܂B
     *
     * tB[h̐: [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]B
     * ftHg: [tmp]B
     *
     * @return tB[h[tmpdir]擾lB
     */
    public String getTmpdir() {
        return fTmpdir;
    }

    /**
     * tB[h [encoding] ̒lݒ肵܂B
     *
     * tB[h̐: [\[Xt@C̕GR[fBOw肵܂B]B
     *
     * @param argEncoding tB[h[encoding]ɐݒ肷lB
     */
    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * tB[h [encoding] ̒l擾܂B
     *
     * tB[h̐: [\[Xt@C̕GR[fBOw肵܂B]B
     *
     * @return tB[h[encoding]擾lB
     */
    public String getEncoding() {
        return fEncoding;
    }

    /**
     * tB[h [targetlang] ̒lݒ肵܂B
     *
     * tB[h̐: [^[QbgƂȂvO~OꏈnBjava, cs, jsI\]B
     *
     * @param argTargetlang tB[h[targetlang]ɐݒ肷lB
     */
    public void setTargetlang(final String argTargetlang) {
        fTargetlang = argTargetlang;
    }

    /**
     * tB[h [targetlang] ̒l擾܂B
     *
     * tB[h̐: [^[QbgƂȂvO~OꏈnBjava, cs, jsI\]B
     * ftHg: [java]B
     *
     * @return tB[h[targetlang]擾lB
     */
    public String getTargetlang() {
        return fTargetlang;
    }

    /**
     * tB[h [runtimepackage] ̒lݒ肵܂B
     *
     * tB[h̐: [^CNX𐶐鐶w肵܂Bw̏ꍇɂ `̒lɐ܂B]B
     *
     * @param argRuntimepackage tB[h[runtimepackage]ɐݒ肷lB
     */
    public void setRuntimepackage(final String argRuntimepackage) {
        fRuntimepackage = argRuntimepackage;
    }

    /**
     * tB[h [runtimepackage] ̒l擾܂B
     *
     * tB[h̐: [^CNX𐶐鐶w肵܂Bw̏ꍇɂ `̒lɐ܂B]B
     *
     * @return tB[h[runtimepackage]擾lB
     */
    public String getRuntimepackage() {
        return fRuntimepackage;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.batchprocess.task.valueobject.BlancoBatchProcessProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",metadir=" + fMetadir);
        buf.append(",targetdir=" + fTargetdir);
        buf.append(",tmpdir=" + fTmpdir);
        buf.append(",encoding=" + fEncoding);
        buf.append(",targetlang=" + fTargetlang);
        buf.append(",runtimepackage=" + fRuntimepackage);
        buf.append("]");
        return buf.toString();
    }
}
