/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sample.jsf;

import java.sql.Connection;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

import blanco.sample.jsf.db.query.SimpleBookInsertInvoker;
import blanco.sample.jsf.db.query.SimpleBookSelectIterator;

/**
 *  [BlancoJsfSample1LogicProxy]C^tF[XB
 *
 * ̃C^tF[Xp [blanco.sample.jsf]pbP[W[BlancoJsfSample1LogicProxy]NX쐬Ďۂ̃ob`ĂB<br>
 */
public class BlancoJsfSample1LogicProxy {
    /**
     * ʁB
     */
    private String fOutcome = "error";

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     *
     * @param event CxgB
     */
    public final void execute(final ActionEvent event) {
        final FacesContext ctx = FacesContext.getCurrentInstance();
        final ELContext elc = ctx.getELContext();
        final ELResolver rslvr = ctx.getApplication().getELResolver();

        // Managed Bean [string] 擾܂B
        String argString = (String) rslvr.getValue(elc, null, "string");
        // Managed Bean [integer] 擾܂B
        Integer argInteger = (Integer) rslvr.getValue(elc, null, "integer");

        final Connection conn = BlancoJsfProxyUtil.getConnection();
        boolean isLogicSuccess = false;
        SimpleBookSelectIterator argSimpleBookSelectIterator = new SimpleBookSelectIterator(conn);

        SimpleBookInsertInvoker argSimpleBookInsertInvoker = new SimpleBookInsertInvoker(conn);

        // ȉ̃R[hŃRpCEG[ꍇɂ́ANX [blanco.sample.jsf.BlancoJsfSample1LogicImpl] VKɍ쐬ĂB
        final BlancoJsfSample1Logic logic = new BlancoJsfSample1LogicImpl();

        try {
            fOutcome = logic.execute(argString, argInteger, argSimpleBookSelectIterator, argSimpleBookInsertInvoker);
            conn.commit();
            isLogicSuccess = true;
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        if (isLogicSuccess == false) {
            try {
                conn.rollback();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        // RlNV̊JB
        BlancoJsfProxyUtil.releaseConnection(conn);
    }

    /**
     * sʂ擾B
     *
     * @return ʏB
     */
    public final String outcome() {
        return fOutcome;
    }
}
