/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.jsf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.db.common.stringgroup.BlancoDbSqlInfoTypeStringGroup;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.jsf.db.BlancoJsfDbParser;
import blanco.jsf.message.BlancoJsfMessage;
import blanco.jsf.valueobject.BlancoJsfSqlItemStructure;
import blanco.jsf.valueobject.BlancoJsfStructure;

/**
 * uob``vExcellob`钊ېeNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoJsfXml2SourceFile {
    /**
     * bZ[WNXB
     */
    protected final BlancoJsfMessage fMsg = new BlancoJsfMessage();

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    /**
     * \[Xt@C̕GR[fBOw肵܂B
     * 
     * @param argEncoding
     *            \[Xt@C̕GR[fBOB
     */
    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public List<BlancoJsfStructure> process(final File argMetaXmlSourceFile,
            final File argDirectoryTarget, final File argDirectoryTargetJee,
            final File argTmp) throws IOException {
        final List<BlancoJsfStructure> result = new ArrayList<BlancoJsfStructure>();

        final BlancoJsfStructure[] structures = new BlancoJsfXmlParser()
                .parse(argMetaXmlSourceFile);
        if (structures == null || structures.length == 0) {
            // ȂB
            return result;
        }

        final List<BlancoDbSqlInfoStructure> sqlInfoList = new BlancoJsfDbParser()
                .process(argTmp);

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2Source(structures[index], sqlInfoList,
                    argDirectoryTarget, argDirectoryTargetJee);
            result.add(structures[index]);
        }

        return result;
    }

    /**
     * ^ꂽNXo[IuWFNgAJava\[XR[h܂B
     * 
     * @param argStructure
     *            B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    public void structure2Source(final BlancoJsfStructure argStructure,
            final List<BlancoDbSqlInfoStructure> sqlInfoList,
            final File argDirectoryTarget, final File argDirectoryTargetJee)
            throws IOException {
        final List<String> sqlClassNameList = getSqlClassNameList(argStructure,
                sqlInfoList);

        {
            final BlancoJsfExpandLogic expandLogic = new BlancoJsfExpandLogic();
            expandLogic.setEncoding(fEncoding);
            expandLogic.expandSourceFile(argStructure, sqlClassNameList,
                    argDirectoryTarget);
        }

        {
            final BlancoJsfExpandLogicProxy expandLogicProxy = new BlancoJsfExpandLogicProxy();
            expandLogicProxy.setEncoding(fEncoding);
            expandLogicProxy.expandSourceFile(argStructure, sqlClassNameList,
                    argDirectoryTargetJee);
        }
    }

    static List<String> getSqlClassNameList(
            final BlancoJsfStructure argProcessStructure,
            final List<BlancoDbSqlInfoStructure> sqlInfoList) {
        final List<String> result = new ArrayList<String>();
        for (BlancoJsfSqlItemStructure sqlItem : argProcessStructure
                .getSqlList()) {
            boolean isFound = false;
            for (BlancoDbSqlInfoStructure sqlinfo : sqlInfoList) {
                if (sqlItem.getName().equals(sqlinfo.getName())) {
                    String basePackage = BlancoStringUtil.null2Blank(sqlinfo
                            .getPackage());
                    if (basePackage.length() == 0) {
                        basePackage = "noname";
                    }
                    final String sqlClassName = basePackage
                            + ".query."
                            + BlancoNameAdjuster.toClassName(sqlItem.getName())
                            + BlancoNameAdjuster
                                    .toUpperCaseTitle(new BlancoDbSqlInfoTypeStringGroup()
                                            .convertToString(sqlinfo.getType()));
                    result.add(sqlClassName);
                    isFound = true;
                    break;
                }
            }
            if (isFound == false) {
                throw new IllegalArgumentException("JSF` ["
                        + argProcessStructure.getName() + "]  SQL`ID ["
                        + sqlItem.getName() + "] ܂B");
            }
        }
        return result;
    }
}
