/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker.odp;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.util.BlancoDbCgUtilDotNet;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 */
public class ExecuteUpdateMethodOdpDotNet extends BlancoDbAbstractMethod {
    public ExecuteUpdateMethodOdpDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                "ExecuteUpdate", "s^NGs܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.setReturn(fCgFactory.createReturn("int", "ꂽs"));

        /*
         * VOLłꍇɂ protectedƂ܂B
         */
        if (fSqlInfo.getSingle()) {
            cgMethod.setAccess("protected");
        } else {
            // publiĉ܂܂łB
        }

        cgMethod.getLangDoc().getDescriptionList().add(
                "f[^x[X̐ᔽꍇɂ IntegrityConstraintException O܂B");

        // BlancoDbCgUtilDotNet.addExceptionToMethodIntegrityConstraintException(
        // fCgFactory, cgMethod, fDbSetting);
        // BlancoDbCgUtilDotNet.addExceptionToMethodDeadlockTimeoutException(
        // fCgFactory, cgMethod, fDbSetting);
        BlancoDbCgUtilDotNet.addExceptionToMethodSqlException(fCgFactory,
                cgMethod);

        if (fSqlInfo.getSingle()) {
            cgMethod.getLangDoc().getDescriptionList().add("");
            cgMethod.getLangDoc().getDescriptionList().add(
                    "VOLȂ̂ŃXR[vprotectedƂ܂B");
            cgMethod.getLangDoc().getDescriptionList().add(
                    "̃\bh̑ ExecuteSingleUpdate\bh𗘗pĂB");
        }

        final List<String> listLine = cgMethod.getLineList();

        if (fDbSetting.getLogging()) {
            BlancoDbCgUtilDotNet.addBeginLogToMethod(cgMethod);
        }

        // statementmۂł΂AIprepareStatementĂяo܂B
        listLine.add("if (fStatement == null) {");
        listLine
                .add("// PreparedStatement擾̏ԂȂ̂ŁAExecuteNonQuery()sɐ旧PrepareStatement()\bhĂяoĎ擾܂B");
        listLine.add("PrepareStatement();");
        listLine.add("}");

        listLine.add("");

        // O܂߂ēWJ܂B
        listLine.add("try {");
        listLine.add("return fStatement.ExecuteNonQuery();");
        listLine.add("} catch (OracleException ex) {");
        listLine.add("throw BlancoDbUtil.ConvertToBlancoException(ex);");
        listLine.add("}");
    }
}