/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.field;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractField;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * QueryNXfStatementtB[hłB
 * 
 * @author IGA Tosiki
 */
public class TransactionFieldDotNet extends BlancoDbAbstractField {
    /**
     * QueryNXfStatementtB[h̃RXgN^łB
     * 
     * @author IGA Tosiki
     */
    public TransactionFieldDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        String statementClassName = "System.Data.SqlClient.SqlTransaction";

        final BlancoCgField cgField = fCgFactory.createField("fTransaction",
                statementClassName, "̃NXIɗpf[^x[XgUNVIuWFNgB");
        fCgClass.getFieldList().add(cgField);

        cgField.getLangDoc().getDescriptionList().add("");
        cgField.getLangDoc().getDescriptionList().add(
                "f[^x[XgUNVIuWFNg̓RXgN^̈ƂĊO^܂B");
        cgField.getLangDoc().getDescriptionList().add(
                "gUNṼR~bg⃍[obŃÃNX̓ł͎s܂B");

        /*
         * WFl[VMbvfUCp^[p\ɂȂړIŁAXR[vprotectedƂ܂B
         */
        cgField.setAccess("protected");
    }
}
