/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.field;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractField;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * QueryNXfLogtB[hłB
 * 
 * @author IGA Tosiki
 */
public class LogFieldDotNet extends BlancoDbAbstractField {
    /**
     * QueryNXfLogtB[h̃RXgN^łB
     * 
     * @param bindClassName
     *            OIuWFNgƂČт̃NXB
     * @author IGA Tosiki
     */
    public LogFieldDotNet(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgField cgField = fCgFactory.createField("fLog",
                "org.apache.commons.logging.Log",
                "̃NXIɗp郍MÔ߂̃IuWFNgIuWFNgB");
        fCgClass.getFieldList().add(cgField);

        cgField.getLangDoc().getDescriptionList().add(
                "̃IuWFNgoRāÃNX̃MOs܂B");
        cgField.setDefault("LogFactory.getLog(" + fCgClass.getName()
                + ".class)");

        cgField.setStatic(true);
        cgField.setFinal(true);

        /*
         * WFl[VMbvfUCp^[p\ɂȂړIŁAXR[vprotectedƂ܂B
         */
        cgField.setAccess("protected");
    }
}
