/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoValueObjectDotNet]̃NX
 */
package blanco.valueobjectdotnet.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.valueobjectdotnet.task.valueobject.BlancoValueObjectDotNetProcessInput;

/**
 * Apache Ant^XN [BlancoValueObjectDotNet]̃NXB
 *
 * BlancoValueObjectDotNetAntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.valueobjectdotnet.task]BlancoValueObjectDotNetBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancovalueobjectdotnet&quot; classname=&quot;blanco.valueobjectdotnet.task.BlancoValueObjectDotNetTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoValueObjectDotNetTask extends Task {
    /**
     * BlancoValueObjectDotNetAntTaskłB
     */
    protected BlancoValueObjectDotNetProcessInput fInput = new BlancoValueObjectDotNetProcessInput();

    /**
     * tB[h [metadir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldMetadirProcessed = false;

    /**
     * tB[h [targetdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * tB[h [tmpdir] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldTmpdirProcessed = false;

    /**
     * tB[h [nameAdjust] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldNameAdjustProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[metadir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNg<br>
     *
     * @param arg Zbgl
     */
    public void setMetadir(final String arg) {
        fInput.setMetadir(arg);
        fIsFieldMetadirProcessed = true;
    }

    /**
     * Ant^XN[metadir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNg<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getMetadir() {
        return fInput.getMetadir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblanco.csp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblanco.csp܂B<br>
     * ftHgl[blanco.cs]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
        fIsFieldTmpdirProcessed = true;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XN[nameAdjust]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * tB[h⃁\bh𖼑Oό`{邩ǂB<br>
     *
     * @param arg Zbgl
     */
    public void setNameAdjust(final String arg) {
        fInput.setNameAdjust(arg);
        fIsFieldNameAdjustProcessed = true;
    }

    /**
     * Ant^XN[nameAdjust]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * tB[h⃁\bh𖼑Oό`{邩ǂB<br>
     * ftHgl[true]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getNameAdjust() {
        return fInput.getNameAdjust();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoValueObjectDotNetTask begin.");

        // ڔԍ[1]AAgr[g[metadir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldMetadirProcessed == false) {
            throw new BuildException("K{Agr[g[metadir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- metadir:[" + getMetadir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
            System.out.println("- nameAdjust:[" + getNameAdjust() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoValueObjectDotNetProcessC^tF[X blanco.valueobjectdotnet.taskpbP[W BlancoValueObjectDotNetProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoValueObjectDotNetProcess proc = new BlancoValueObjectDotNetProcessImpl();
            if (proc.execute(fInput) != BlancoValueObjectDotNetBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
