/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.tmx;

import java.io.File;
import java.io.IOException;

import junit.framework.TestCase;
import blanco.tmx.valueobject.BlancoTmx;
import blanco.tmx.valueobject.BlancoTmxTu;
import blanco.tmx.valueobject.BlancoTmxTuv;

/**
 * XLIFF𑀍삷邽߂̃[eBeB[B
 * 
 * @author IGA Tosiki
 */
public class BlancoTmxTest extends TestCase {
    /**
     * XLIFF`ւ̃VACYs܂B
     * 
     * @param args
     * @throws IOException
     */
    public void testSerializer() throws Exception {
        new File("./tmp/tmx/").mkdirs();
        final BlancoTmx tmx = new BlancoTmx();
        {
            final BlancoTmxTu tu = new BlancoTmxTu();
            tmx.getBody().getTuList().add(tu);
            tu.setTuid("myid");

            final BlancoTmxTuv tuvEn = new BlancoTmxTuv();
            tu.getTuvList().add(tuvEn);
            tuvEn.setLang("en_US");
            tuvEn.setSeg("This is a pen.");

            final BlancoTmxTuv tuvJa = new BlancoTmxTuv();
            tu.getTuvList().add(tuvJa);
            tuvJa.setLang("ja_JP");
            tuvJa.setSeg("̓yłB");
        }
        {
            final BlancoTmxTu tu = new BlancoTmxTu();
            tmx.getBody().getTuList().add(tu);
            tu.setTuid("myid2");

            final BlancoTmxTuv tuvEn = new BlancoTmxTuv();
            tu.getTuvList().add(tuvEn);
            tuvEn.setLang("en_US");
            tuvEn.setSeg("This is a pen.");

            final BlancoTmxTuv tuvJa = new BlancoTmxTuv();
            tu.getTuvList().add(tuvJa);
            tuvJa.setLang("ja_JP");
            tuvJa.setSeg("̓yłB");
        }
        new BlancoTmxSerializer().serialize(tmx, new File(
                "./tmp/tmx/org.dummy.test.tmx"));

        final BlancoTmx tmx2 = new BlancoTmxParser().parse(new File(
                "./tmp/tmx/org.dummy.test.tmx"));
        new BlancoTmxSerializer().serialize(tmx2, new File(
                "./tmp/tmx/org.dummy.test2.tmx"));

    }
}
