/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipsenls.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.eclipsenls.BlancoEclipseNlsConstants;
import blanco.eclipsenls.BlancoEclipseNlsMeta2Xml;
import blanco.eclipsenls.BlancoEclipseNlsXml2PropertiesFile;
import blanco.eclipsenls.BlancoEclipseNlsXml2SourceFile;
import blanco.eclipsenls.message.BlancoEclipseNlsMessage;
import blanco.eclipsenls.task.valueobject.BlancoEclipseNlsProcessInput;

public class BlancoEclipseNlsProcessImpl implements BlancoEclipseNlsProcess {
    /**
     * bZ[WB
     */
    private final BlancoEclipseNlsMessage fMsg = new BlancoEclipseNlsMessage();

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     * 
     * @param input
     *            ̓̓p[^B
     * @return ̎sʁB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int execute(final BlancoEclipseNlsProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoEclipseNlsConstants.PRODUCT_NAME + " ("
                + BlancoEclipseNlsConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fMsg.getMbenla01(input
                        .getMetadir()));
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoEclipseNlsConstants.TARGET_SUBDIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoEclipseNlsMeta2Xml().processDirectory(fileMetadir, input
                    .getTmpdir()
                    + BlancoEclipseNlsConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoEclipseNlsConstants.TARGET_SUBDIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                final BlancoEclipseNlsXml2SourceFile xml2sourceFile = new BlancoEclipseNlsXml2SourceFile();
                xml2sourceFile.setEncoding(input.getEncoding());
                xml2sourceFile.process(fileMeta2[index], new File(input
                        .getTargetdir()));

                final BlancoEclipseNlsXml2PropertiesFile xml2PropertiesFile = new BlancoEclipseNlsXml2PropertiesFile();
                xml2PropertiesFile.process(fileMeta2[index], new File(input
                        .getTargetdir()));
            }

            return BlancoEclipseNlsBatchProcess.END_SUCCESS;
        } catch (TransformerException ex) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + ex.toString());
        }
    }
}
