/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipsenls;

import java.io.File;
import java.io.IOException;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.eclipsenls.valueobject.BlancoEclipseNlsFieldStructure;
import blanco.eclipsenls.valueobject.BlancoEclipseNlsStructure;

/**
 * uEclipse NLS `vExcell烁bZ[WNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoEclipseNlsXml2SourceFile {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final File argDirectoryTarget) throws IOException {
        final BlancoEclipseNlsStructure[] structures = new BlancoEclipseNlsXmlParser()
                .parse(argMetaXmlSourceFile);

        for (int index = 0; index < structures.length; index++) {
            // ^̉͌ʂƂɃ\[XR[hs܂B
            structure2Source(structures[index], argDirectoryTarget);
        }
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param argStructure
     *            ^XN̍\B
     * @param argDirectoryTarget
     *            o͐fBNg
     */
    public void structure2Source(final BlancoEclipseNlsStructure argStructure,
            final File argDirectoryTarget) {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argStructure.getPackage(),
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.setEncoding(fEncoding);
        fCgClass = fCgFactory.createClass(BlancoNameAdjuster
                .toClassName(argStructure.getName()), BlancoStringUtil
                .null2Blank(argStructure.getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getExtendClassList().add(
                fCgFactory.createType("org.eclipse.osgi.util.NLS"));

        fCgClass.getLangDoc().getDescriptionList().add(
                "̃NX́AEclipse NLS ̂߂̃NXłB");

        {
            final BlancoCgField field = new BlancoCgField();
            field.setName("BUNDLE_NAME");
            field.setType(fCgFactory.createType("java.lang.String"));
            field.setDescription("vpeBt@C̊ꖼpbP[WCtɂ́B");
            field.setDefault("\"" + argStructure.getPackage() + "."
                    + argStructure.getBaseName() + "\"");
            field.setFinal(true);
            field.setAccess("private");
            field.setStatic(true);
            fCgClass.getFieldList().add(field);
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "staticInitializer", "tB[h̏{܂B");
            fCgClass.getMethodList().add(cgMethod);
            cgMethod.setStaticInitializer(true);
            cgMethod.getLineList().add(
                    "NLS.initializeMessages(BUNDLE_NAME, " + fCgClass.getName()
                            + ".class);");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(fCgClass
                    .getName(), "RXgN^B܂B");
            fCgClass.getMethodList().add(cgMethod);
            cgMethod.setConstructor(true);
            cgMethod.setAccess("private");
        }

        for (int indexField = 0; indexField < argStructure.getFieldList()
                .size(); indexField++) {
            final BlancoEclipseNlsFieldStructure fieldLook = argStructure
                    .getFieldList().get(indexField);
            expandFieldEclipseNls(argStructure, fieldLook);
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * NLS ̃tB[hWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandFieldEclipseNls(
            final BlancoEclipseNlsStructure argProcessStructure,
            final BlancoEclipseNlsFieldStructure fieldLook) {
        final String fieldName = fieldLook.getName();

        final BlancoCgField cgField = fCgFactory.createField(fieldName,
                "java.lang.String", "Eclipse NLS `ID["
                        + argProcessStructure.getName() + "]AL[["
                        + fieldLook.getName() + "]̕łB");
        fCgClass.getFieldList().add(cgField);
        cgField.setAccess("public");
        cgField.setStatic(true);
        // Eclipse NLS ł̓ftHgl̐ݒ肪ł悤ɔfB

        cgField.getLangDoc().getDescriptionList().add(
                "["
                        + BlancoJavaSourceUtil.escapeStringAsJavaDoc(fieldLook
                                .getMessage()
                                + "]"));
    }
}
