/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.valueobject.resourcebundle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoValueObject]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoValueObjectResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoValueObjectResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoValueObject]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoValueObjectResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoValueObject");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoValueObjectResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoValueObject]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoValueObjectResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoValueObject", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoValueObjectResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoValueObject]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoValueObjectResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoValueObject", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoValueObject], key[METAFILE_DISPLAYNAME]
     *
     * [o[IuWFNg`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "o[IuWFNg`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObject], key[META2XML.ELEMENT_COMMON]
     *
     * [blancovalueobject-common] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_COMMON]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementCommon() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancovalueobject-common";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_COMMON");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObject], key[META2XML.ELEMENT_LIST]
     *
     * [blancovalueobject-list] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_LIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementList() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancovalueobject-list";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_LIST");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.ERR001]
     *
     * [NX[{0}]̃pbP[Ww肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "NX[{0}]̃pbP[Ww肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.ERR002]
     *
     * [NX[{0}]̃tB[h[{1}]̌^w肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr002(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "NX[{0}]̃tB[h[{1}]̌^w肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.ERR003]
     *
     * [NX[{0}] ŃtB[hw肳ĂȂ̂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr003(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "NX[{0}] ŃtB[hw肳ĂȂ̂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.ERR004]
     *
     * [NX[{0}] tB[h[{1}]́u^vw肳Ă܂Bu^vw肵ĂB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr004(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "NX[{0}] tB[h[{1}]́u^vw肳Ă܂Bu^vw肵ĂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.ERR005]
     *
     * [NX[{0}] tB[h[{1}]́uftHgl({2})vZbgĂ܂Bu{3}v̓ftHglT|[g܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr005(final String arg0, final String arg1, final String arg2, final String arg3) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "NX[{0}] tB[h[{1}]́uftHgl({2})vZbgĂ܂Bu{3}v̓ftHglT|[g܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.FIELD.NAME]
     *
     * [tB[h [{0}]] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.FIELD.NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassFieldName(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "tB[h [{0}]";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.FIELD.NAME");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.FIELD.TYPE]
     *
     * [ڂ̌^ [{0}]&lt;br&gt;] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.FIELD.TYPE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassFieldType(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ڂ̌^ [{0}]<br>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.FIELD.TYPE");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.FIELD.DEFAULT]
     *
     * [Kl   [{0}]&lt;br&gt;] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.FIELD.DEFAULT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassFieldDefault(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "Kl   [{0}]<br>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.FIELD.DEFAULT");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.SET.JAVADOC.01]
     *
     * [tB[h [{0}]̃Zb^[\bh] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.SET.JAVADOC.01]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassSetJavadoc01(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "tB[h [{0}]̃Zb^[\bh";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.SET.JAVADOC.01");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.SET.JAVADOC.02]
     *
     * [ڂ̌^ [{0}]&lt;br&gt;] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.SET.JAVADOC.02]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassSetJavadoc02(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ڂ̌^ [{0}]<br>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.SET.JAVADOC.02");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.SET.ARG.JAVADOC]
     *
     * [tB[h[{0}]Ɋi[l] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.SET.ARG.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassSetArgJavadoc(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "tB[h[{0}]Ɋi[l";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.SET.ARG.JAVADOC");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.GET.JAVADOC.01]
     *
     * [tB[h[{0}]̃Qb^[\bh] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.GET.JAVADOC.01]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassGetJavadoc01(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "tB[h[{0}]̃Qb^[\bh";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.GET.JAVADOC.01");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.GET.JAVADOC.02]
     *
     * [ڂ̌^ [{0}]&lt;br&gt;] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.GET.JAVADOC.02]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassGetJavadoc02(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ڂ̌^ [{0}]<br>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.GET.JAVADOC.02");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.GET.ARG.JAVADOC]
     *
     * [Kl   [{0}]&lt;br&gt;] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.GET.ARG.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassGetArgJavadoc(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "Kl   [{0}]<br>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.GET.ARG.JAVADOC");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[XML2JAVACLASS.GET.RETURN.JAVADOC]
     *
     * [tB[h[{0}]Ɋi[Ăl] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.GET.RETURN.JAVADOC]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassGetReturnJavadoc(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "tB[h[{0}]Ɋi[Ăl";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.GET.RETURN.JAVADOC");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoValueObject], key[ANTTASK.ERR001]
     *
     * [^fBNg[{0}]݂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[ANTTASK.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getAnttaskErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^fBNg[{0}]݂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("ANTTASK.ERR001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
