/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.encryption;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

import blanco.encryption.message.BlancoEncryptionMessage;

/**
 * gvDES (Triple DES) ASYɂt@CÍc[ Level2B
 * 
 * @author IGA Tosiki
 */
public class BlancoEncryptionDesede2 {
    /**
     * bZ[WB
     */
    private final BlancoEncryptionMessage fMsg = new BlancoEncryptionMessage();

    /**
     * ÍȂ܂B
     * 
     * Iɂ ZIP`i[GZIPks܂B
     * 
     * @param argFileInput
     *            ̓t@CB
     * @param argFileOutput
     *            o̓t@C(Í)B
     * @param argPassword
     *            ÍpX[hB
     * @throws IOException
     *             o͗O ꍇB
     */
    public void encrypt(final File argFileInput, final File argFileOutput,
            final String argPassword) throws IOException {
        // TODO ̓p[^`FbN̎B
        // TODO t@C݃`FbNB

        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(argFileInput));
        final ZipOutputStream outStream = new ZipOutputStream(
                new BufferedOutputStream(new FileOutputStream(argFileOutput)));

        outStream.setLevel(ZipOutputStream.DEFLATED);

        final ZipEntry zipEntry = new ZipEntry(argFileInput.getName());
        zipEntry.setTime(argFileInput.lastModified());
        outStream.putNextEntry(zipEntry);

        new BlancoEncryptionDesede().encrypt(inStream, outStream, argPassword);

        // TODO mclose̎B
        inStream.close();
        outStream.flush();
        outStream.close();

        // ŌɃt@C̓tRs[܂B
        if (argFileOutput.setLastModified(argFileInput.lastModified()) == false) {
            throw new IllegalArgumentException(fMsg.getMbecde21());
        }
    }

    /**
     * s܂B
     * 
     * Iɂ GZIPLZIP`os܂B
     * 
     * @param argFileInput
     *            ̓t@C(Í)B
     * @param argFileOutput
     *            o̓t@CB
     * @param argPassword
     *            ÍpX[hB
     * @throws IOException
     *             o͗O ꍇB
     */
    public void decrypt(final File argFileInput, final File argFileDir,
            final String argPassword) throws IOException {
        // TODO ̓p[^`FbN̎B
        // TODO t@C݃`FbNB

        // TODO ߂l`FbNB
        argFileDir.mkdirs();

        try {
            final ZipInputStream inStream = new ZipInputStream(
                    new BufferedInputStream(new FileInputStream(argFileInput)));

            final ZipEntry zipEntry = inStream.getNextEntry();

            final File fileOutput = new File(argFileDir.getAbsolutePath() + "/"
                    + zipEntry.getName());

            final OutputStream outStream = new BufferedOutputStream(
                    new FileOutputStream(fileOutput));

            new BlancoEncryptionDesede().decrypt(inStream, outStream,
                    argPassword);

            inStream.closeEntry();

            // TODO mclose̎B
            inStream.close();
            outStream.flush();
            outStream.close();

            // ŌɃt@C̓tRs[܂B
            if (fileOutput.setLastModified(zipEntry.getTime()) == false) {
                throw new IllegalArgumentException(fMsg.getMbecde22());
            }
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fMsg.getMbecde23(e.toString()));
        }
    }
}
