/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import jp.sourceforge.mergedoc.pleiades.aspect.Analyses;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class Asyncs {
    private static final Logger log = Logger.getLogger(Asyncs.class);
    private static ExecutorService threadPool = Executors.newCachedThreadPool();

    private Asyncs() {
    }

    public static void execute(Runnable command) {
        long start = System.nanoTime();
        if (threadPool == null) {
            String msg = "\u975e\u540c\u671f\u5b9f\u884c\u306f\u3059\u3067\u306b\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u3055\u308c\u3066\u3044\u307e\u3059\u3002";
            log.fatal(msg, new Object[0]);
            throw new IllegalStateException(msg);
        }
        try {
            threadPool.execute(command);
        }
        catch (RejectedExecutionException e) {
            log.warn("RejectedExecutionException \u304c\u767a\u751f\u3057\u305f\u305f\u3081\u3001\u540c\u671f\u5b9f\u884c\u3057\u307e\u3059\u3002", new Object[0]);
            command.run();
        }
        Analyses.end(Asyncs.class, "execute", start);
    }

    public static void shutdown() {
        if (threadPool != null) {
            log.debug("\u975e\u540c\u671f\u5b9f\u884c\u3092\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u3057\u307e\u3059\u3002", new Object[0]);
            threadPool.shutdown();
            threadPool = null;
        }
    }
}

