import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.omegat.core.data.LegacyTM;
import org.omegat.core.data.StringEntry;
import org.omegat.core.data.StringEntryWrapper;
import org.omegat.core.matching.FuzzyMatcherWrapper;
import org.omegat.core.matching.NearString;

public class Test extends TestCase {

    public void testTest() {

        FuzzyMatcherWrapper fuzzyMatcher = FuzzyMatcherWrapper.getInstance();
        List<StringEntry> tmStrings = new ArrayList<StringEntry>();

        StringEntryWrapper tuEntry = new StringEntryWrapper("This is source text.");

        {
            StringEntryWrapper tmEntry = new StringEntryWrapper("This is target text.");
            tmEntry.setTranslation("̓^[QbgEeLXgłB");
            tmStrings.add(tmEntry);
        }

        {
            StringEntryWrapper tmEntry = new StringEntryWrapper("This is source text.");
            tmEntry.setTranslation("̓\[XEeLXgłB");
            tmStrings.add(tmEntry);
        }

        LegacyTM legacyTm = new LegacyTM("test", tmStrings);
        List<LegacyTM> tmList = new ArrayList<LegacyTM>();
        tmList.add(legacyTm);
        
        List<NearString> nearList = fuzzyMatcher.match(tuEntry, tmList);

        System.out.println(nearList.size()
                + "̃}b`݂܂B");
        for (int i = 0; i < nearList.size(); i++) {
            NearString nearString = nearList.get(i);
            System.out.println("------------------------------------");
            System.out.println((i + 1) + "");
            System.out.println(nearString.score + "%}b`");
            System.out.println(nearString.str.getTranslation());
        }
        System.out.println("------------------------------------");
        System.out.println("");
    }

    public void test2Test() {
        // eXgs
        testTest();
    }

}
