/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class OmegaTFileChooser
extends JFileChooser {
    private static ImageIcon omegatIcon = null;

    public OmegaTFileChooser() {
        this(Preferences.getPreference("current_folder"));
    }

    public OmegaTFileChooser(String string) {
        super(string);
        try {
            if (omegatIcon == null) {
                omegatIcon = new ImageIcon(this.getClass().getResource("/org/omegat/gui/resources/OmegaT_small.gif"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Icon getIcon(File file) {
        if (OmegaTFileChooser.isProjectDir(file) && omegatIcon != null) {
            return omegatIcon;
        }
        return super.getIcon(file);
    }

    public String getTypeDescription(File file) {
        if (OmegaTFileChooser.isProjectDir(file)) {
            return OStrings.getString("PFC_OMEGAT_PROJECT");
        }
        return super.getTypeDescription(file);
    }

    public static boolean isProjectDir(File file) {
        if (file == null || file.getName().length() == 0) {
            return false;
        }
        File file2 = new File(file.getAbsolutePath() + File.separator + "omegat.project");
        File file3 = new File(file.getAbsolutePath() + File.separator + "omegat");
        return file2.exists() && file3.exists() && file3.isDirectory();
    }
}

