/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omegat.filters2.TranslationException;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLStreamReader;

public class Preferences {
    public static final String FILE_PREFERENCES = "omegat.prefs";
    public static final String SOURCE_LOCALE = "source_lang";
    public static final String TARGET_LOCALE = "target_lang";
    public static final String CURRENT_FOLDER = "current_folder";
    public static final String SOURCE_FOLDER = "source_folder";
    public static final String TARGET_FOLDER = "target_folder";
    public static final String TM_FOLDER = "tm_folder";
    public static final String GLOSSARY_FOLDER = "glossary_folder";
    public static final String MAINWINDOW_WIDTH = "screen_width";
    public static final String MAINWINDOW_HEIGHT = "screen_height";
    public static final String MAINWINDOW_X = "screen_x";
    public static final String MAINWINDOW_Y = "screen_y";
    public static final String MAINWINDOW_LAYOUT = "docking_layout";
    public static final String PROJECT_FILES_WINDOW_WIDTH = "project_files_window_width";
    public static final String PROJECT_FILES_WINDOW_HEIGHT = "project_files_window_height";
    public static final String PROJECT_FILES_WINDOW_X = "project_files_window_x";
    public static final String PROJECT_FILES_WINDOW_Y = "project_files_window_y";
    public static final String PROJECT_FILES_USE_FONT = "project_files_use_font";
    public static final String SEARCHWINDOW_WIDTH = "search_window_width";
    public static final String SEARCHWINDOW_HEIGHT = "search_window_height";
    public static final String SEARCHWINDOW_X = "search_window_x";
    public static final String SEARCHWINDOW_Y = "search_window_y";
    public static final String SEARCHWINDOW_SEARCH_TYPE = "search_window_search_type";
    public static final String SEARCHWINDOW_CASE_SENSITIVE = "search_window_case_sensitive";
    public static final String SEARCHWINDOW_REG_EXPRESSIONS = "search_window_reg_expressions";
    public static final String SEARCHWINDOW_TM_SEARCH = "search_window_tm_search";
    public static final String SEARCHWINDOW_DIR = "search_window_dir";
    public static final String SEARCHWINDOW_SEARCH_FILES = "search_window_search_files";
    public static final String SEARCHWINDOW_RECURSIVE = "search_window_search_recursive";
    public static final String TAGVWINDOW_WIDTH = "tagv_window_width";
    public static final String TAGVWINDOW_HEIGHT = "tagv_window_height";
    public static final String TAGVWINDOW_X = "tagv_window_x";
    public static final String TAGVWINDOW_Y = "tagv_window_y";
    public static final String HELPWINDOW_WIDTH = "help_window_width";
    public static final String HELPWINDOW_HEIGHT = "help_window_height";
    public static final String HELPWINDOW_X = "help_window_x";
    public static final String HELPWINDOW_Y = "help_window_y";
    public static final String USE_TAB_TO_ADVANCE = "tab_advance";
    public static final String ALWAYS_CONFIRM_QUIT = "always_confirm_quit";
    public static final String MARK_TRANSLATED_SEGMENTS = "mark_translated_segments";
    public static final String MARK_UNTRANSLATED_SEGMENTS = "mark_untranslated_segments";
    public static final String DONT_INSERT_SOURCE_TEXT = "wf_noSourceText";
    public static final String ALLOW_TRANS_EQUAL_TO_SRC = "wf_allowTransEqualToSrc";
    public static final String BEST_MATCH_INSERT = "wf_insertBestMatch";
    public static final String BEST_MATCH_MINIMAL_SIMILARITY = "wf_minimalSimilarity";
    public static final String BEST_MATCH_MINIMAL_SIMILARITY_DEFAULT = "80";
    public static final String BEST_MATCH_EXPLANATORY_TEXT = "wf_explanatoryText";
    public static final String EXPORT_CURRENT_SEGMENT = "wf_exportCurrentSegment";
    public static final String ALLOW_AUTO_SPELLCHECKING = "allow_auto_spellchecking";
    public static final String SPELLCHECKER_DICTIONARY_DIRECTORY = "spellcheker_dir";
    public static final String DISPLAY_SEGMENT_SOURCES = "display_segment_sources";
    public static final String FILTERS_VERSION = "filters_version";
    private static boolean m_loaded = false;
    private static boolean m_changed;
    private static List<String> m_nameList;
    private static List<String> m_valList;
    private static Map<String, Integer> m_preferenceMap;

    public static String getPreference(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        if (!m_loaded) {
            Preferences.doLoad();
        }
        Integer n = m_preferenceMap.get(string);
        String string2 = "";
        if (n != null) {
            string2 = m_valList.get(n);
        }
        return string2;
    }

    public static boolean isPreference(String string) {
        return "true".equals(Preferences.getPreference(string));
    }

    public static String getPreferenceDefault(String string, String string2) {
        String string3 = Preferences.getPreference(string);
        if (string3.equals("")) {
            string3 = string2;
            Preferences.setPreference(string, string2);
        }
        return string3;
    }

    public static int getPreferenceDefault(String string, int n) {
        String string2 = Preferences.getPreferenceDefault(string, Integer.toString(n));
        int n2 = n;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static void setPreference(String string, String string2) {
        m_changed = true;
        if (string != null && string.length() != 0 && string2 != null) {
            Integer n;
            if (!m_loaded) {
                Preferences.doLoad();
            }
            if ((n = m_preferenceMap.get(string)) == null) {
                n = m_valList.size();
                m_preferenceMap.put(string, n);
                m_valList.add(string2);
                m_nameList.add(string);
            } else {
                m_valList.set(n, string2);
            }
        }
    }

    public static void setPreference(String string, boolean bl) {
        Preferences.setPreference(string, String.valueOf(bl));
    }

    public static void setPreference(String string, int n) {
        Preferences.setPreference(string, String.valueOf(n));
    }

    public static void save() {
        try {
            if (m_changed) {
                Preferences.doSave();
            }
        }
        catch (IOException iOException) {
            Log.logErrorRB("PM_ERROR_SAVE", new Object[0]);
            Log.log(iOException);
        }
    }

    private static void doLoad() {
        try {
            m_loaded = true;
            XMLStreamReader xMLStreamReader = new XMLStreamReader();
            xMLStreamReader.killEmptyBlocks();
            xMLStreamReader.setStream(new File(StaticUtils.getConfigDir() + FILE_PREFERENCES));
            m_preferenceMap.clear();
            if (xMLStreamReader.advanceToTag("omegat") == null) {
                return;
            }
            XMLBlock xMLBlock = xMLStreamReader.advanceToTag("preference");
            if (xMLBlock == null) {
                return;
            }
            String string = xMLBlock.getAttribute("version");
            if (string != null && !string.equals("1.0")) {
                return;
            }
            List<XMLBlock> list = xMLStreamReader.closeBlock(xMLBlock);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                xMLBlock = list.get(i);
                if (xMLBlock.isClose() || !xMLBlock.isTag()) continue;
                String string2 = xMLBlock.getTagName();
                if ((xMLBlock = list.get(++i)).isTag()) continue;
                String string3 = xMLBlock.getText();
                if (string2 == null || string2.equals("") || string3 == null) continue;
                m_preferenceMap.put(string2, m_valList.size());
                m_nameList.add(string2);
                m_valList.add(string3);
            }
        }
        catch (TranslationException translationException) {
            Log.logWarningRB("PM_WARNING_PARSEERROR_ON_READ", new Object[0]);
            Log.log(translationException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Log.logWarningRB("PM_WARNING_PARSEERROR_ON_READ", new Object[0]);
            Log.log(indexOutOfBoundsException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.logErrorRB("PM_UNSUPPORTED_ENCODING", new Object[0]);
            Log.log(unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Log.logErrorRB("PM_ERROR_READING_FILE", new Object[0]);
            Log.log(iOException);
        }
    }

    private static void doSave() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(StaticUtils.getConfigDir() + FILE_PREFERENCES), "UTF-8"));
        bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        bufferedWriter.write("<omegat>\n");
        bufferedWriter.write("  <preference version=\"1.0\">\n");
        for (int i = 0; i < m_nameList.size(); ++i) {
            String string = m_nameList.get(i);
            String string2 = StaticUtils.makeValidXML(m_valList.get(i));
            if (string2.equals("")) continue;
            bufferedWriter.write("    <" + string + ">");
            bufferedWriter.write(string2);
            bufferedWriter.write("</" + string + ">\n");
        }
        bufferedWriter.write("  </preference>\n");
        bufferedWriter.write("</omegat>\n");
        bufferedWriter.close();
        m_changed = false;
    }

    static {
        m_preferenceMap = new HashMap<String, Integer>(64);
        m_nameList = new ArrayList<String>(32);
        m_valList = new ArrayList<String>(32);
        m_changed = false;
        Preferences.doLoad();
    }
}

