/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class Log {
    private static Logger LOGGER;

    public static String getLogLocation() {
        return StaticUtils.getConfigDir() + "/logs";
    }

    public static void log(String string) {
        LOGGER.info(string);
    }

    public static void logRB(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LogRecord logRecord = new LogRecord(Level.INFO, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    public static void log(Throwable throwable) {
        LOGGER.log(Level.SEVERE, "", throwable);
    }

    public static void logWarningRB(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LogRecord logRecord = new LogRecord(Level.WARNING, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    public static void logInfoRB(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LogRecord logRecord = new LogRecord(Level.INFO, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    public static void logErrorRB(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    public static void logErrorRB(Throwable throwable, String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, string);
            logRecord.setResourceBundle(OStrings.getResourceBundle());
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(LOGGER.getName());
            logRecord.setThrown(throwable);
            LOGGER.log(logRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream;
        LOGGER = Logger.global;
        boolean bl = false;
        File file = new File(StaticUtils.getConfigDir(), "logger.properties");
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
                try {
                    LogManager.getLogManager().readConfiguration(inputStream);
                    bl = true;
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                inputStream = Log.class.getResourceAsStream("/org/omegat/logger.properties");
                try {
                    LogManager.getLogManager().readConfiguration(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Can't open file for logging", iOException);
            }
        }
    }
}

