/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.NearString;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.matches.FindMatchesThread;
import org.omegat.gui.matches.IMatcher;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchesTextArea
extends JTextPane
implements IMatcher {
    private final List<NearString> matches = new ArrayList<NearString>();
    private final List<Integer> delimiters = new ArrayList<Integer>();
    private int activeMatch;
    private final MainWindow mw;
    protected StringEntry processedEntry;

    public MatchesTextArea(MainWindow mainWindow) {
        this.mw = mainWindow;
        this.setFont(Core.getMainWindow().getApplicationFont());
        String string = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Fuzzy_Matches");
        Core.getMainWindow().addDockable(new DockableScrollPane("MATCHES", string, this, true));
        this.setEditable(false);
        this.setMinimumSize(new Dimension(100, 50));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MatchesTextArea.this.onMouseClick(mouseEvent);
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            public void onNewFile(String string) {
            }

            public void onEntryActivated(StringEntry stringEntry) {
                MatchesTextArea.this.processedEntry = stringEntry;
                new FindMatchesThread(MatchesTextArea.this, stringEntry).start();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font font) {
                MatchesTextArea.this.setFont(font);
            }
        });
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                switch (pROJECT_CHANGE_TYPE) {
                    case CREATE: 
                    case LOAD: 
                    case CLOSE: {
                        MatchesTextArea.this.clear();
                    }
                }
            }
        });
    }

    @Override
    public NearString getActiveMatch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.activeMatch < 0 || this.activeMatch >= this.matches.size()) {
            return null;
        }
        return this.matches.get(this.activeMatch);
    }

    protected void setMatches(List<NearString> list) {
        UIThreadsUtil.mustBeSwingThread();
        this.activeMatch = -1;
        this.matches.clear();
        this.delimiters.clear();
        this.matches.addAll(list);
        this.delimiters.add(0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            NearString nearString = list.get(i);
            stringBuffer.append(MessageFormat.format("{0}) {1}\n{2}\n<{3}/{4}/{5}% {6} >", i + 1, nearString.str.getSrcText(), nearString.str.getTranslation(), nearString.score, nearString.scoreNoStem, nearString.adjustedScore, nearString.proj));
            if (i < list.size() - 1) {
                stringBuffer.append("\n\n");
            }
            this.delimiters.add(stringBuffer.length());
        }
        this.setText(stringBuffer.toString());
        this.setActiveMatch(0);
        this.checkForReplaceTranslation();
    }

    private void checkForReplaceTranslation() {
        if (this.matches.isEmpty()) {
            return;
        }
        if (Preferences.isPreference("wf_insertBestMatch")) {
            String string = Preferences.getPreferenceDefault("wf_minimalSimilarity", "80");
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                Log.log("ERROR: exception while parsing percentage:");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                Log.log(exception);
                return;
            }
            NearString nearString = this.matches.get(0);
            if (nearString.score >= n) {
                String string2 = Preferences.getPreferenceDefault("wf_explanatoryText", OStrings.getString("WF_DEFAULT_PREFIX")) + nearString.str.getTranslation();
                SourceTextEntry sourceTextEntry = Core.getEditor().getCurrentEntry();
                if (StringUtil.isEmpty(sourceTextEntry.getTranslation())) {
                    Core.getEditor().replaceEditText(string2);
                }
            }
        }
    }

    @Override
    public void setActiveMatch(int n) {
        int n2;
        UIThreadsUtil.mustBeSwingThread();
        if (n < 0 || n >= this.matches.size() || this.activeMatch == n) {
            return;
        }
        this.activeMatch = n;
        this.selectAll();
        this.setCharacterAttributes(Styles.PLAIN, true);
        int n3 = this.delimiters.get(n);
        int n4 = this.delimiters.get(n + 1);
        NearString nearString = this.matches.get(n);
        Token[] tokenArray = Core.getTokenizer().tokenizeAllExactly(nearString.str.getSrcText());
        byte[] byArray = nearString.attr;
        for (n2 = 0; n2 < tokenArray.length; ++n2) {
            Token token = tokenArray[n2];
            int n5 = n3 + 3 + token.getOffset();
            int n6 = n3 + 3 + token.getOffset() + token.getLength();
            this.select(n5, n6);
            if ((byArray[n2] & 1) != 0) {
                this.setCharacterAttributes(Styles.TEXT_EXTRA, false);
                continue;
            }
            if ((byArray[n2] & 2) == 0) continue;
            this.setCharacterAttributes(Styles.TEXT_BORDER, false);
        }
        this.select(n3, n4);
        this.setCharacterAttributes(Styles.BOLD, false);
        this.setCaretPosition(n4 - 2);
        n2 = n3;
        this.setCaretPosition(n2);
    }

    public void clear() {
        this.processedEntry = null;
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                MatchesTextArea.this.setMatches(new ArrayList<NearString>());
            }
        });
    }

    private void onMouseClick(MouseEvent mouseEvent) {
        if (this.matches == null || this.matches.isEmpty()) {
            return;
        }
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
            int n;
            int n2 = -1;
            int n3 = this.viewToModel(mouseEvent.getPoint());
            for (int i = 0; i < this.delimiters.size() - 1; ++i) {
                n = this.delimiters.get(i);
                int n4 = this.delimiters.get(i + 1);
                if (n3 < n || n3 >= n4) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                n2 = this.delimiters.size() - 1;
            }
            n = n2;
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = jPopupMenu.add(OStrings.getString("MATCHES_INSERT"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MatchesTextArea.this.setActiveMatch(n);
                    MatchesTextArea.this.mw.doInsertTrans();
                }
            });
            jMenuItem = jPopupMenu.add(OStrings.getString("MATCHES_REPLACE"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MatchesTextArea.this.setActiveMatch(n);
                    MatchesTextArea.this.mw.doRecycleTrans();
                }
            });
            jPopupMenu.addSeparator();
            if (n >= this.matches.size()) {
                return;
            }
            final NearString nearString = this.matches.get(n);
            String string = nearString.proj;
            jMenuItem = jPopupMenu.add(OStrings.getString("MATCHES_GO_TO_SEGMENT_SOURCE"));
            if (string == null || string.equals("")) {
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Core.getEditor().gotoEntry(nearString.str.getParentList().first().entryNum() + 1);
                    }
                });
            } else {
                jMenuItem.setEnabled(false);
            }
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

