/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.dialogs.AboutDialog;
import org.omegat.gui.dialogs.FontSelectionDialog;
import org.omegat.gui.dialogs.SpellcheckerConfigurationDialog;
import org.omegat.gui.dialogs.WorkflowOptionsDialog;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.filters2.FiltersCustomizer;
import org.omegat.gui.help.HelpFrame;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.search.SearchWindow;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.SwingWorker;

public class MainWindowMenuHandler {
    private final MainWindow mainWindow;

    public MainWindowMenuHandler(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void projectNewMenuItemActionPerformed() {
        ProjectUICommands.projectCreate();
    }

    public void projectOpenMenuItemActionPerformed() {
        ProjectUICommands.projectOpen();
    }

    public void projectImportMenuItemActionPerformed() {
        this.mainWindow.doImportSourceFiles();
    }

    public void projectWikiImportMenuItemActionPerformed() {
        this.mainWindow.doWikiImport();
    }

    public void projectReloadMenuItemActionPerformed() {
        ProjectUICommands.projectReload();
    }

    public void projectCloseMenuItemActionPerformed() {
        ProjectUICommands.projectClose();
    }

    public void projectSaveMenuItemActionPerformed() {
        ProjectUICommands.projectSave();
    }

    public void projectCompileMenuItemActionPerformed() {
        ProjectUICommands.projectCompile();
    }

    public void projectEditMenuItemActionPerformed() {
        ProjectUICommands.projectEditProperties();
    }

    public void viewFileListMenuItemActionPerformed() {
        if (this.mainWindow.m_projWin == null) {
            this.mainWindow.menu.viewFileListMenuItem.setSelected(false);
            return;
        }
        if (!this.mainWindow.m_projWin.isActive()) {
            this.mainWindow.m_projWin.buildDisplay();
            this.mainWindow.m_projWin.setVisible(true);
            this.mainWindow.m_projWin.toFront();
        } else {
            this.mainWindow.m_projWin.setVisible(false);
        }
    }

    private void flushExportedSegments() {
        FileUtil.writeScriptFile("", "source.txt");
        FileUtil.writeScriptFile("", "target.txt");
    }

    public void projectExitMenuItemActionPerformed() {
        boolean bl = false;
        if (Core.getProject().isProjectLoaded()) {
            bl = Core.getProject().isProjectModified();
        }
        if ((bl || Preferences.isPreference("always_confirm_quit")) && 0 != JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_QUIT_CONFIRM"), OStrings.getString("CONFIRM_DIALOG_TITLE"), 0)) {
            return;
        }
        this.flushExportedSegments();
        new SwingWorker<Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                MainWindowUI.saveScreenLayout(MainWindowMenuHandler.this.mainWindow);
                Preferences.save();
                if (Core.getProject().isProjectLoaded()) {
                    ISpellChecker iSpellChecker = Core.getSpellChecker();
                    iSpellChecker.saveWordLists();
                    Core.getProject().saveProject();
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    System.exit(0);
                }
                catch (Exception exception) {
                    Log.logErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(exception, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public void editUndoMenuItemActionPerformed() {
        Core.getEditor().undo();
    }

    public void editRedoMenuItemActionPerformed() {
        Core.getEditor().redo();
    }

    public void editOverwriteTranslationMenuItemActionPerformed() {
        this.mainWindow.doRecycleTrans();
    }

    public void editInsertTranslationMenuItemActionPerformed() {
        this.mainWindow.doInsertTrans();
    }

    public void editOverwriteSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().replaceEditText(Core.getEditor().getCurrentEntry().getSrcText());
    }

    public void editInsertSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().insertText(Core.getEditor().getCurrentEntry().getSrcText());
    }

    public void editExportSelectionMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String string = Core.getEditor().getSelectedText();
        if (string == null) {
            string = Core.getEditor().getCurrentEntry().isTranslated() ? Core.getEditor().getCurrentEntry().getTranslation() : Core.getEditor().getCurrentEntry().getSrcText();
        }
        FileUtil.writeScriptFile(string, "selection.txt");
    }

    public void editFindInProjectMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String string = Core.getEditor().getSelectedText();
        if (string != null) {
            string.trim();
        }
        SearchWindow searchWindow = new SearchWindow(this.mainWindow, string);
        searchWindow.setVisible(true);
        this.mainWindow.addSearchWindow(searchWindow);
    }

    public void editSelectFuzzy1MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(0);
    }

    public void editSelectFuzzy2MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(1);
    }

    public void editSelectFuzzy3MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(2);
    }

    public void editSelectFuzzy4MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(3);
    }

    public void editSelectFuzzy5MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(4);
    }

    public void cycleSwitchCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.CYCLE);
    }

    public void titleCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.TITLE);
    }

    public void upperCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.UPPER);
    }

    public void lowerCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.LOWER);
    }

    public void gotoNextUntranslatedMenuItemActionPerformed() {
        Core.getEditor().nextUntranslatedEntry();
    }

    public void gotoNextSegmentMenuItemActionPerformed() {
        Core.getEditor().nextEntry();
    }

    public void gotoPreviousSegmentMenuItemActionPerformed() {
        Core.getEditor().prevEntry();
    }

    public void gotoSegmentMenuItemActionPerformed() {
        final JOptionPane jOptionPane = new JOptionPane(OStrings.getString("MW_PROMPT_SEG_NR_MSG"), -1, 2);
        jOptionPane.setWantsInput(true);
        final JDialog jDialog = new JDialog(this.mainWindow, OStrings.getString("MW_PROMPT_SEG_NR_TITLE"), true);
        jDialog.setContentPane(jOptionPane);
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jDialog.isVisible() && propertyChangeEvent.getSource() == jOptionPane) {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = jOptionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if (string.equals("inputValue") || string.equals("value") && (Integer)object == 0) {
                        jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        String string2 = (String)jOptionPane.getInputValue();
                        int n = Core.getProject().getAllEntries().size();
                        if (string2 == null || string2.trim().length() == 0) {
                            this.displayErrorMessage(n);
                            return;
                        }
                        int n2 = -1;
                        try {
                            n2 = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.displayErrorMessage(n);
                            return;
                        }
                        if (n2 < 1 || n2 > n) {
                            this.displayErrorMessage(n);
                            return;
                        }
                    }
                    jDialog.setVisible(false);
                }
            }

            private void displayErrorMessage(int n) {
                JOptionPane.showMessageDialog(jDialog, StaticUtils.format(OStrings.getString("MW_SEGMENT_NUMBER_ERROR"), n), OStrings.getString("TF_ERROR"), 0);
            }
        });
        jDialog.pack();
        jDialog.setLocationRelativeTo(Core.getMainWindow().getApplicationFrame());
        jDialog.setVisible(true);
        Object object = jOptionPane.getInputValue();
        if (object != null && !object.equals(JOptionPane.UNINITIALIZED_VALUE)) {
            try {
                Core.getEditor().gotoEntry(Integer.parseInt((String)object));
            }
            catch (ClassCastException classCastException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void gotoHistoryBackMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryBack();
    }

    public void gotoHistoryForwardMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryForward();
    }

    public void viewMarkTranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkTranslated(this.mainWindow.menu.viewMarkTranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkUntranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkUntranslated(this.mainWindow.menu.viewMarkUntranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewDisplaySegmentSourceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplaySegmentSources(this.mainWindow.menu.viewDisplaySegmentSourceCheckBoxMenuItem.isSelected());
    }

    public void toolsValidateTagsMenuItemActionPerformed() {
        Core.getTagValidation().validateTags();
    }

    public void optionsTabAdvanceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setUseTabForAdvance(this.mainWindow.menu.optionsTabAdvanceCheckBoxMenuItem.isSelected());
    }

    public void optionsAlwaysConfirmQuitCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("always_confirm_quit", this.mainWindow.menu.optionsAlwaysConfirmQuitCheckBoxMenuItem.isSelected());
    }

    public void optionsFontSelectionMenuItemActionPerformed() {
        FontSelectionDialog fontSelectionDialog = new FontSelectionDialog((Frame)Core.getMainWindow().getApplicationFrame(), Core.getMainWindow().getApplicationFont());
        fontSelectionDialog.setVisible(true);
        if (fontSelectionDialog.getReturnStatus() == 1) {
            this.mainWindow.setApplicationFont(fontSelectionDialog.getSelectedFont());
        }
    }

    public void optionsSetupFileFiltersMenuItemActionPerformed() {
        FiltersCustomizer filtersCustomizer = new FiltersCustomizer(this.mainWindow);
        filtersCustomizer.setVisible(true);
        if (filtersCustomizer.getReturnStatus() == 1) {
            int n;
            FilterMaster.getInstance().saveConfig();
            if (Core.getProject().isProjectLoaded() && (n = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
                ProjectUICommands.projectReload();
            }
        } else {
            FilterMaster.getInstance().loadConfig();
        }
    }

    public void optionsSentsegMenuItemActionPerformed() {
        int n;
        SegmentationCustomizer segmentationCustomizer = new SegmentationCustomizer(this.mainWindow);
        segmentationCustomizer.setVisible(true);
        if (segmentationCustomizer.getReturnStatus() == 1 && Core.getProject().isProjectLoaded() && (n = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
            ProjectUICommands.projectReload();
        }
    }

    public void optionsSpellCheckMenuItemActionPerformed() {
        Language language = null;
        language = Core.getProject().isProjectLoaded() ? Core.getProject().getProjectProperties().getTargetLanguage() : new Language(Preferences.getPreference("target_lang"));
        SpellcheckerConfigurationDialog spellcheckerConfigurationDialog = new SpellcheckerConfigurationDialog((Frame)this.mainWindow, language);
        spellcheckerConfigurationDialog.setVisible(true);
        if (spellcheckerConfigurationDialog.getReturnStatus() == 1) {
            boolean bl = Preferences.isPreference("allow_auto_spellchecking");
            if (bl && Core.getProject().isProjectLoaded()) {
                ISpellChecker iSpellChecker = Core.getSpellChecker();
                iSpellChecker.destroy();
                iSpellChecker.initialize();
            }
            Core.getEditor().getSettings().setAutoSpellChecking(bl);
        }
    }

    public void optionsWorkflowMenuItemActionPerformed() {
        new WorkflowOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsRestoreGUIMenuItemActionPerformed() {
        MainWindowUI.resetDesktopLayout(this.mainWindow);
    }

    public void helpContentsMenuItemActionPerformed() {
        HelpFrame helpFrame = HelpFrame.getInstance();
        helpFrame.setVisible(true);
        helpFrame.toFront();
    }

    public void helpAboutMenuItemActionPerformed() {
        new AboutDialog(this.mainWindow).setVisible(true);
    }
}

