/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.Font;
import java.io.File;
import java.util.List;
import javax.swing.JTextPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.StringEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.glossary.FindGlossaryThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.OStrings;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryTextArea
extends JTextPane {
    protected final GlossaryManager manager = new GlossaryManager();
    protected StringEntry processedEntry;

    public GlossaryTextArea() {
        this.setEditable(false);
        this.setFont(Core.getMainWindow().getApplicationFont());
        String string = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary");
        Core.getMainWindow().addDockable(new DockableScrollPane("GLOSSARY", string, this, true));
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                switch (pROJECT_CHANGE_TYPE) {
                    case LOAD: 
                    case CREATE: {
                        GlossaryTextArea.this.clear();
                        GlossaryTextArea.this.loadGlossaries();
                        break;
                    }
                    case CLOSE: {
                        GlossaryTextArea.this.clear();
                        GlossaryTextArea.this.closeGlossaries();
                    }
                }
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            public void onNewFile(String string) {
            }

            public void onEntryActivated(StringEntry stringEntry) {
                GlossaryTextArea.this.processedEntry = stringEntry;
                new FindGlossaryThread(GlossaryTextArea.this, stringEntry).start();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font font) {
                GlossaryTextArea.this.setFont(font);
            }
        });
    }

    protected void setGlossaryEntries(List<GlossaryEntry> list) {
        UIThreadsUtil.mustBeSwingThread();
        StringBuffer stringBuffer = new StringBuffer();
        for (GlossaryEntry glossaryEntry : list) {
            stringBuffer.append(glossaryEntry.getSrcText() + " = " + glossaryEntry.getLocText());
            if (glossaryEntry.getCommentText().length() > 0) {
                stringBuffer.append("\n" + glossaryEntry.getCommentText());
            }
            stringBuffer.append("\n\n");
        }
        this.setText(stringBuffer.toString());
    }

    public void clear() {
        this.setText(new String());
    }

    protected void loadGlossaries() {
        final File file = new File(Core.getProject().getProjectProperties().getGlossaryRoot());
        new Thread(){

            public void run() {
                GlossaryTextArea.this.manager.loadGlossaryFiles(file);
            }
        }.start();
    }

    protected void closeGlossaries() {
        this.manager.clear();
    }
}

