/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.data.StringEntry;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.Tokenizer;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.util.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindGlossaryThread
extends Thread {
    private final GlossaryTextArea glossaryController;
    private final StringEntry processedEntry;
    private List<GlossaryEntry> result = new ArrayList<GlossaryEntry>();

    public FindGlossaryThread(GlossaryTextArea glossaryTextArea, StringEntry stringEntry) {
        this.glossaryController = glossaryTextArea;
        this.processedEntry = stringEntry;
    }

    @Override
    public void run() {
        Object object;
        Object object2;
        Token[] tokenArray = Core.getTokenizer().tokenizeWords(this.processedEntry.getSrcText(), ITokenizer.StemmingMode.GLOSSARY);
        List<GlossaryEntry> list = this.glossaryController.manager.getGlossaryEntries();
        if (list != null) {
            for (GlossaryEntry glossaryEntry : list) {
                if (this.glossaryController.processedEntry != this.processedEntry) {
                    return;
                }
                object2 = glossaryEntry.getSrcText();
                object = Core.getTokenizer().tokenizeWords((String)object2, ITokenizer.StemmingMode.GLOSSARY);
                int n = ((Token[])object).length;
                if (n == 0 || !Tokenizer.isContainsAll(tokenArray, (Token[])object)) continue;
                this.result.add(glossaryEntry);
            }
        }
        this.result = this.FilterGlossary(this.result);
        for (int i = 0; i < this.result.size(); ++i) {
            for (int j = i + 1; j < this.result.size() - 1; ++j) {
                object2 = this.result.get(i);
                object = this.result.get(j);
                if (((GlossaryEntry)object).getSrcText().length() <= ((GlossaryEntry)object2).getSrcText().length()) continue;
                GlossaryEntry glossaryEntry = this.result.get(j);
                this.result.set(j, this.result.get(i));
                this.result.set(i, glossaryEntry);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (((FindGlossaryThread)FindGlossaryThread.this).glossaryController.processedEntry == FindGlossaryThread.this.processedEntry) {
                    FindGlossaryThread.this.glossaryController.setGlossaryEntries(FindGlossaryThread.this.result);
                }
            }
        });
    }

    private List FilterGlossary(List<GlossaryEntry> list) {
        Object object;
        Object object2;
        int n;
        if (list.size() == 0) {
            return list;
        }
        LinkedList<GlossaryEntry> linkedList = new LinkedList<GlossaryEntry>();
        GlossaryEntry glossaryEntry = new GlossaryEntry("", "", "");
        boolean bl = false;
        for (n = 0; n < list.size(); ++n) {
            object2 = list.get(n);
            if (((GlossaryEntry)object2).getSrcText().equals("")) continue;
            for (int i = n + 1; i < list.size(); ++i) {
                object = list.get(i);
                if (((GlossaryEntry)object).getSrcText().equals("") || !((GlossaryEntry)object2).getSrcText().equals(((GlossaryEntry)object).getSrcText()) || !((GlossaryEntry)object2).getLocText().equals(((GlossaryEntry)object).getLocText()) || !((GlossaryEntry)object2).getCommentText().equals(((GlossaryEntry)object).getCommentText())) continue;
                list.set(i, glossaryEntry);
                bl = true;
            }
        }
        if (bl) {
            Iterator<GlossaryEntry> iterator = list.iterator();
            object2 = new LinkedList();
            while (iterator.hasNext()) {
                GlossaryEntry glossaryEntry2 = iterator.next();
                if (glossaryEntry2.getSrcText().equals("") || glossaryEntry2.getLocText().equals("")) {
                    iterator.remove();
                    continue;
                }
                object2.add((GlossaryEntry)glossaryEntry2);
            }
            list = object2;
        }
        for (n = 0; n < list.size(); ++n) {
            Object object3;
            Object object4;
            object2 = new LinkedList<GlossaryEntry>();
            GlossaryEntry glossaryEntry3 = list.get(n);
            if (glossaryEntry3.getSrcText().equals("")) continue;
            object2.add((GlossaryEntry)glossaryEntry3);
            for (int i = n + 1; i < list.size(); ++i) {
                object4 = list.get(i);
                if (((GlossaryEntry)object4).getSrcText().equals("") || !glossaryEntry3.getSrcText().equals(((GlossaryEntry)object4).getSrcText())) continue;
                object2.add((GlossaryEntry)object4);
                list.set(i, glossaryEntry);
            }
            object = new LinkedList();
            if (object2.size() > 1) {
                for (int i = 0; i < object2.size(); ++i) {
                    object3 = (GlossaryEntry)object2.get(i);
                    if (((GlossaryEntry)object3).getSrcText().equals("")) continue;
                    object.add((GlossaryEntry)object3);
                    for (int j = i + 1; j < object2.size(); ++j) {
                        GlossaryEntry glossaryEntry4 = (GlossaryEntry)object2.get(j);
                        if (glossaryEntry4.getSrcText().equals("") || !((GlossaryEntry)object3).getLocText().equals(glossaryEntry4.getLocText())) continue;
                        object.add((GlossaryEntry)glossaryEntry4);
                        object2.set(j, (GlossaryEntry)glossaryEntry);
                    }
                }
            } else {
                object = object2;
            }
            object4 = ((GlossaryEntry)object.get(0)).getSrcText();
            object3 = ((GlossaryEntry)object.get(0)).getLocText();
            String string = "";
            int n2 = 1;
            String string2 = ((GlossaryEntry)object.get(0)).getLocText();
            String string3 = ((GlossaryEntry)object.get(0)).getCommentText();
            if (!string3.equals("")) {
                string = n2 + ". " + string3;
            }
            for (int i = 1; i < object.size(); ++i) {
                if (!((GlossaryEntry)object.get(i)).getLocText().equals(string2)) {
                    ++n2;
                    string2 = ((GlossaryEntry)object.get(i)).getLocText();
                    object3 = (String)object3 + ", " + string2;
                    if (((GlossaryEntry)object.get(i)).getCommentText().equals("")) continue;
                    if (string.equals("")) {
                        string = n2 + ". " + ((GlossaryEntry)object.get(i)).getCommentText();
                        continue;
                    }
                    string = string + "\n" + n2 + ". " + ((GlossaryEntry)object.get(i)).getCommentText();
                    continue;
                }
                if (((GlossaryEntry)object.get(i)).getCommentText().equals("")) continue;
                string = string.equals("") ? n2 + ". " + ((GlossaryEntry)object.get(i)).getCommentText() : string + "\n" + n2 + ". " + ((GlossaryEntry)object.get(i)).getCommentText();
            }
            GlossaryEntry glossaryEntry5 = new GlossaryEntry((String)object4, (String)object3, string);
            linkedList.add(glossaryEntry5);
        }
        return linkedList;
    }
}

