/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Utilities;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.DocumentSegment;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorTextArea;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EditorSpellChecking {
    private static final String IMPOSSIBLE = "Should not have happened, report to http://sf.net/tracker/?group_id=68187&atid=520347";

    EditorSpellChecking() {
    }

    protected static void checkSpelling(boolean bl, EditorController editorController, EditorTextArea editorTextArea) {
        try {
            int n;
            int n2;
            int n3 = editorTextArea.getCaretPosition();
            int n4 = editorController.getTranslationStart();
            int n5 = editorController.getTranslationEnd();
            if (bl) {
                n2 = n4;
                n = n5;
            } else {
                int n6 = Utilities.getPreviousWord(editorTextArea, n3);
                int n7 = Utilities.getWordEnd(editorTextArea, n6);
                int n8 = Utilities.getNextWord(editorTextArea, n3);
                int n9 = Utilities.getWordEnd(editorTextArea, n8);
                n2 = n6 < n4 ? n4 : n6;
                n = n9 > n5 ? n5 : n9;
            }
            String string = editorTextArea.getText(n2, n - n2);
            AttributeSet attributeSet = editorController.getSettings().getTranslatedAttributeSet();
            MutableAttributeSet mutableAttributeSet = Styles.applyStyles(attributeSet, Styles.MISSPELLED);
            AbstractDocument abstractDocument = (AbstractDocument)editorTextArea.getDocument();
            abstractDocument.removeUndoableEditListener(editorTextArea.undoManager);
            abstractDocument.replace(n2, n - n2, string, attributeSet);
            for (Token token : Core.getTokenizer().tokenizeWordsForSpelling(string)) {
                String string2 = token.getTextFromString(string);
                AttributeSet attributeSet2 = !Core.getSpellChecker().isCorrect(string2) ? mutableAttributeSet : attributeSet;
                abstractDocument.replace(n2 + token.getOffset(), token.getLength(), string2, attributeSet2);
            }
            editorTextArea.setCaretPosition(n3);
            abstractDocument.addUndoableEditListener(editorTextArea.undoManager);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected static boolean createSpellCheckerPopUp(Point point, final EditorController editorController, final EditorTextArea editorTextArea) {
        int n = editorTextArea.viewToModel(point);
        if (n < editorController.getTranslationStart() || n > editorController.getTranslationEnd()) {
            return false;
        }
        try {
            final int n2 = Utilities.getWordStart(editorTextArea, n);
            int n3 = Utilities.getWordEnd(editorTextArea, n);
            final String string = editorTextArea.getText(n2, n3 - n2);
            final AbstractDocument abstractDocument = (AbstractDocument)editorTextArea.getDocument();
            if (!Core.getSpellChecker().isCorrect(string)) {
                Object object;
                List<String> list = Core.getSpellChecker().suggest(string);
                editorTextArea.popup = new JPopupMenu();
                for (final String object22 : list) {
                    JMenuItem jMenuItem = editorTextArea.popup.add(object22);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                int n = editorTextArea.getCaretPosition();
                                abstractDocument.replace(n2, string.length(), object22, editorController.getSettings().getTranslatedAttributeSet());
                                editorTextArea.setCaretPosition(n);
                            }
                            catch (BadLocationException badLocationException) {
                                System.err.println(badLocationException);
                            }
                        }
                    });
                }
                if (list.size() == 0) {
                    object = editorTextArea.popup.add(OStrings.getString("SC_NO_SUGGESTIONS"));
                    ((AbstractButton)object).addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                }
                editorTextArea.popup.add(new JSeparator());
                object = new ChangeUserDictionary(editorController, editorTextArea);
                JMenuItem jMenuItem = editorTextArea.popup.add(OStrings.getString("SC_IGNORE_ALL"));
                jMenuItem.addActionListener(new ActionListener((ChangeUserDictionary)object, string, n2){
                    final /* synthetic */ ChangeUserDictionary val$changeHandler;
                    final /* synthetic */ String val$word;
                    final /* synthetic */ int val$wordStart;
                    {
                        this.val$changeHandler = changeUserDictionary;
                        this.val$word = string;
                        this.val$wordStart = n;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$changeHandler.addIgnoreWord(this.val$word, this.val$wordStart, false);
                    }
                });
                JMenuItem jMenuItem2 = editorTextArea.popup.add(OStrings.getString("SC_ADD_TO_DICTIONARY"));
                jMenuItem2.addActionListener(new ActionListener((ChangeUserDictionary)object, string, n2){
                    final /* synthetic */ ChangeUserDictionary val$changeHandler;
                    final /* synthetic */ String val$word;
                    final /* synthetic */ int val$wordStart;
                    {
                        this.val$changeHandler = changeUserDictionary;
                        this.val$word = string;
                        this.val$wordStart = n;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$changeHandler.addIgnoreWord(this.val$word, this.val$wordStart, true);
                    }
                });
                editorTextArea.popup.show(editorTextArea, (int)point.getX(), (int)point.getY());
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logRB(IMPOSSIBLE, new Object[0]);
            Log.log(badLocationException);
        }
        return true;
    }

    protected static List<Token> checkSpelling(int n, String string, EditorController editorController, EditorTextArea editorTextArea) {
        Token[] tokenArray = Core.getTokenizer().tokenizeWordsForSpelling(string);
        ArrayList<Token> arrayList = new ArrayList<Token>();
        AbstractDocument abstractDocument = (AbstractDocument)editorTextArea.getDocument();
        AttributeSet attributeSet = editorController.getSettings().getTranslatedAttributeSet();
        for (Token token : tokenArray) {
            int n2 = token.getOffset();
            int n3 = n2 + token.getLength();
            String string2 = string.substring(n2, n3);
            if (Core.getSpellChecker().isCorrect(string2)) continue;
            try {
                abstractDocument.replace(n + n2, token.getLength(), string2, Styles.applyStyles(attributeSet, Styles.MISSPELLED));
            }
            catch (BadLocationException badLocationException) {
                Log.log(badLocationException);
            }
            arrayList.add(token);
        }
        return arrayList;
    }

    private static class ChangeUserDictionary {
        private final EditorController controller;
        private final EditorTextArea editor;

        public ChangeUserDictionary(EditorController editorController, EditorTextArea editorTextArea) {
            this.controller = editorController;
            this.editor = editorTextArea;
        }

        protected void addIgnoreWord(String string, int n, boolean bl) {
            UIThreadsUtil.mustBeSwingThread();
            if (bl) {
                Core.getSpellChecker().learnWord(string);
            } else {
                Core.getSpellChecker().ignoreWord(string);
            }
            AbstractDocument abstractDocument = (AbstractDocument)this.editor.getDocument();
            try {
                abstractDocument.replace(n, string.length(), string, this.controller.getSettings().getTranslatedAttributeSet());
                int n2 = this.controller.m_segmentStartOffset;
                int n3 = this.controller.getTranslationEnd() - this.controller.getTranslationStart();
                int n4 = this.controller.m_sourceDisplayLength + OConsts.segmentStartStringFull.length() + n3 + OConsts.segmentEndStringFull.length() + 2;
                int n5 = this.controller.m_curEntryNum - this.controller.m_xlFirstEntry;
                DocumentSegment documentSegment = this.controller.m_docSegList[n5];
                documentSegment.length = n4;
                int n6 = 0;
                int n7 = 0;
                for (int i = this.controller.m_xlFirstEntry; i <= this.controller.m_xlLastEntry; ++i) {
                    SourceTextEntry sourceTextEntry = Core.getProject().getAllEntries().get(i);
                    if (sourceTextEntry.isTranslated() && n6 != n5) {
                        String string2;
                        int n8 = n7;
                        if (this.controller.getSettings().isDisplaySegmentSources()) {
                            n8 += sourceTextEntry.getSrcText().length() + 1;
                        }
                        if ((string2 = sourceTextEntry.getTranslation()).indexOf(string) != -1) {
                            for (Token token : Core.getTokenizer().tokenizeWordsForSpelling(string2)) {
                                String string3 = token.getTextFromString(string2);
                                if (!string3.equals(string)) continue;
                                abstractDocument.replace(n8 + token.getOffset(), string.length(), string, this.controller.getSettings().getTranslatedAttributeSet());
                            }
                        }
                    }
                    n7 += this.controller.m_docSegList[n6++].length;
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logRB(EditorSpellChecking.IMPOSSIBLE, new Object[0]);
                Log.log(badLocationException);
            }
        }
    }
}

