/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.docbook;

import java.io.BufferedReader;
import java.util.regex.Matcher;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.docbook.DocBookDialect;
import org.omegat.util.OStrings;

public class DocBookFilter
extends XMLFilter {
    public DocBookFilter() {
        super(new DocBookDialect());
    }

    public String getFileFormatName() {
        return OStrings.getString("DocBook_FILTER_NAME");
    }

    public String getHint() {
        return OStrings.getString("DocBook_HINT");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xml", null, null), new Instance("*.dbk", null, null)};
    }

    public boolean isSourceEncodingVariable() {
        return false;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    public boolean isFileSupported(BufferedReader bufferedReader) {
        XMLDialect xMLDialect = this.getDialect();
        if (xMLDialect.getConstraints() == null || xMLDialect.getConstraints().size() == 0) {
            return true;
        }
        try {
            char[] cArray = new char[8192];
            int n = bufferedReader.read(cArray);
            String string = new String(cArray, 0, n);
            Matcher matcher = DocBookDialect.DOCBOOK_PUBLIC_DTD.matcher(string);
            if (matcher.find()) {
                return true;
            }
            matcher = DocBookDialect.DB5_XMLNS.matcher(string);
            if (!matcher.find()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

