/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.Attribute;
import org.omegat.filters3.Element;
import org.omegat.filters3.Entry;
import org.omegat.filters3.Tag;
import org.omegat.filters3.xml.Comment;
import org.omegat.filters3.xml.DTD;
import org.omegat.filters3.xml.Entity;
import org.omegat.filters3.xml.Translator;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.filters3.xml.XMLEntityText;
import org.omegat.filters3.xml.XMLIntactTag;
import org.omegat.filters3.xml.XMLOutOfTurnTag;
import org.omegat.filters3.xml.XMLTag;
import org.omegat.filters3.xml.XMLText;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Handler
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    private SAXParser parser;
    private Translator translator;
    private XMLDialect dialect;
    private File inFile;
    private String inEncoding;
    private File outFile;
    private String outEncoding;
    private BufferedWriter mainWriter;
    private BufferedWriter extWriter = null;
    private Entity extEntity = null;
    Entry entry;
    Stack<Entry> outofturnEntries = new Stack();
    Entry intacttagEntry = null;
    String intacttagName = null;
    private List<Entity> externalEntities = new ArrayList<Entity>();
    private Map<String, Entity> internalEntities = new HashMap<String, Entity>();
    private Entity internalEntityStarted = null;
    private boolean inCDATA = false;
    private DTD dtd = null;
    private boolean inDTD = false;
    private List<File> processedFiles = new ArrayList<File>();
    private static final String START_JARSCHEMA = "jar:";
    private static final String START_FILESCHEMA = "file:";
    private String sourceFolderAbsolutePath = null;

    private BufferedWriter currWriter() {
        if (this.extWriter != null) {
            return this.extWriter;
        }
        return this.mainWriter;
    }

    private boolean collectingOutOfTurnText() {
        return !this.outofturnEntries.empty();
    }

    private boolean collectingIntactText() {
        return this.intacttagEntry != null;
    }

    private Entry currEntry() {
        if (this.collectingIntactText()) {
            return this.intacttagEntry;
        }
        if (this.collectingOutOfTurnText()) {
            return this.outofturnEntries.peek();
        }
        return this.entry;
    }

    public List<File> getProcessedFiles() {
        if (this.processedFiles.size() > 0) {
            return this.processedFiles;
        }
        return null;
    }

    private void reportFatalError(SAXParseException sAXParseException) throws SAXException, MalformedURLException, URISyntaxException {
        File file;
        int n = sAXParseException.getLineNumber();
        String string = sAXParseException.getSystemId() != null ? ((file = new File(this.inFile.getParentFile(), this.localizeSystemId(sAXParseException.getSystemId()))).exists() ? file.getAbsolutePath() : this.inFile.getAbsolutePath()) : this.inFile.getAbsolutePath();
        throw new SAXException("\n" + StaticUtils.format(sAXParseException.getMessage() + "\n" + OStrings.getString("XML_FATAL_ERROR"), string, new Integer(n)));
    }

    public Handler(SAXParser sAXParser, Translator translator, XMLDialect xMLDialect, File file, String string, File file2, String string2) throws IOException {
        this.parser = sAXParser;
        this.translator = translator;
        this.dialect = xMLDialect;
        this.inFile = file;
        this.inEncoding = string;
        this.outFile = file2;
        this.outEncoding = string2;
        this.mainWriter = translator.createWriter(file2, string2);
    }

    private String getSourceFolderAbsolutePath() {
        if (this.sourceFolderAbsolutePath == null) {
            String string = this.inFile.getAbsoluteFile().getParent();
            try {
                string = this.inFile.getCanonicalFile().getParent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string.charAt(string.length() - 1) != File.separatorChar) {
                string = string + File.separatorChar;
            }
            this.sourceFolderAbsolutePath = string;
        }
        return this.sourceFolderAbsolutePath;
    }

    private String localizeSystemId(String string) throws URISyntaxException, MalformedURLException {
        File file;
        String string2;
        if (string.startsWith(START_FILESCHEMA) && (string2 = (file = new File(new URL(string).toURI())).getAbsolutePath()).startsWith(this.getSourceFolderAbsolutePath())) {
            return string2.substring(this.getSourceFolderAbsolutePath().length());
        }
        return string;
    }

    private boolean isInSource(String string) throws URISyntaxException, MalformedURLException {
        File file;
        return string.startsWith(START_FILESCHEMA) && (file = new File(new URL(string).toURI())).getAbsolutePath().startsWith(this.getSourceFolderAbsolutePath());
    }

    private Entity findExternalEntity(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        for (Entity entity : this.externalEntities) {
            if (entity.isInternal() || !StaticUtils.equal(string, entity.getPublicId()) || !StaticUtils.equal(string2, entity.getSystemId())) continue;
            return entity;
        }
        return null;
    }

    private void doStartEntity(String string) {
        if (this.inDTD) {
            return;
        }
        this.internalEntityStarted = this.internalEntities.get(string);
    }

    private void doEndEntity(String string) throws SAXException, TranslationException, IOException {
        if (this.inDTD || this.extEntity == null) {
            return;
        }
        if (this.extEntity.getName().equals(string)) {
            this.extEntity = null;
            this.translateAndFlush();
            this.extWriter.close();
            this.extWriter = null;
            this.mainWriter.write('&' + string + ';');
        }
    }

    public InputSource doResolve(String string, String string2) throws SAXException, TranslationException, IOException, URISyntaxException {
        if (this.dtd != null && StaticUtils.equal(string, this.dtd.getPublicId()) && (StaticUtils.equal(string2, this.dtd.getSystemId()) || StaticUtils.equal(this.localizeSystemId(string2), this.dtd.getSystemId()))) {
            this.inDTD = true;
        }
        if (string2 != null && (string2.startsWith(START_JARSCHEMA) || string2.startsWith(START_FILESCHEMA))) {
            InputSource inputSource = new InputSource(string2);
            if (string2.startsWith(START_FILESCHEMA) && !new File(new URI(string2)).exists()) {
                inputSource = null;
            }
            if (inputSource != null) {
                if (!this.inDTD && this.outFile != null && this.isInSource(string2) && this.extEntity == null) {
                    this.extEntity = this.findExternalEntity(string, this.localizeSystemId(string2));
                    if (this.extEntity != null) {
                        this.translateAndFlush();
                        File file = new File(this.outFile.getParentFile(), this.localizeSystemId(string2));
                        this.processedFiles.add(new File(this.inFile.getParent(), this.localizeSystemId(string2)));
                        this.extWriter = this.translator.createWriter(file, this.outEncoding);
                        this.extWriter.write("<?xml version=\"1.0\"?>\n");
                    }
                }
                return inputSource;
            }
            return new InputSource(new StringReader(new String()));
        }
        InputSource inputSource = this.dialect.resolveEntity(string, string2);
        if (inputSource != null) {
            return inputSource;
        }
        return new InputSource(new StringReader(new String()));
    }

    private void queueText(String string) {
        if (this.internalEntityStarted != null && string.equals(this.internalEntityStarted.getValue())) {
            this.currEntry().add(new XMLEntityText(this.internalEntityStarted));
        } else {
            XMLText xMLText;
            Element element;
            boolean bl = false;
            if (this.currEntry().size() > 0 && (element = this.currEntry().get(this.currEntry().size() - 1)) instanceof XMLText && (xMLText = (XMLText)element).isInCDATA() == this.inCDATA) {
                this.currEntry().remove(this.currEntry().size() - 1);
                this.currEntry().add(new XMLText(xMLText.getText() + string, this.inCDATA));
                bl = true;
            }
            if (!bl) {
                this.currEntry().add(new XMLText(string, this.inCDATA));
            }
        }
    }

    private void queueTag(String string, Attributes attributes) {
        Tag tag;
        XMLIntactTag xMLIntactTag = null;
        if (!this.collectingIntactText() && this.isIntactTag(string)) {
            xMLIntactTag = new XMLIntactTag(string, this.getShortcut(string), attributes);
            tag = xMLIntactTag;
            this.intacttagName = string;
        } else {
            tag = new XMLTag(string, this.getShortcut(string), 1, attributes);
        }
        this.currEntry().add(tag);
        if (xMLIntactTag != null) {
            this.intacttagEntry = xMLIntactTag.getIntactContents();
        }
        if (!this.collectingIntactText()) {
            for (int i = 0; i < tag.getAttributes().size(); ++i) {
                Attribute attribute = tag.getAttributes().get(i);
                if (!this.dialect.getTranslatableAttributes().contains(attribute.getName()) && !this.dialect.getTranslatableTagAttributes().containsPair(string, attribute.getName()) || !this.dialect.validateTranslatableTagAttribute(string, attribute.getName(), tag.getAttributes()).booleanValue()) continue;
                attribute.setValue(this.translator.translate(attribute.getValue()));
            }
        }
    }

    private void queueEndTag(String string) {
        int n = this.currEntry().size();
        if (n > 0 && this.currEntry().get(n - 1) instanceof XMLTag && ((XMLTag)this.currEntry().get(n - 1)).getTag().equals(string) && ((XMLTag)this.currEntry().get(n - 1)).getType() == 1) {
            ((XMLTag)this.currEntry().get(n - 1)).setType(3);
        } else {
            this.currEntry().add(new XMLTag(string, this.getShortcut(string), 2, null));
        }
    }

    private void queueComment(String string) {
        this.currEntry().add(new Comment(string));
    }

    private void queueDTD(DTD dTD) {
        this.currEntry().add(dTD);
    }

    private void start(String string, Attributes attributes) throws SAXException, TranslationException {
        if (this.isOutOfTurnTag(string)) {
            XMLOutOfTurnTag xMLOutOfTurnTag = new XMLOutOfTurnTag(string, this.getShortcut(string), attributes);
            this.currEntry().add(xMLOutOfTurnTag);
            this.outofturnEntries.push(xMLOutOfTurnTag.getEntry());
        } else {
            if (this.isParagraphTag(string) && !this.collectingOutOfTurnText() && !this.collectingIntactText()) {
                this.translateAndFlush();
            }
            this.queueTag(string, attributes);
        }
    }

    private void end(String string) throws SAXException, TranslationException {
        if (this.collectingIntactText() && this.isIntactTag(string) && string.equals(this.intacttagName)) {
            this.intacttagEntry = null;
            this.intacttagName = null;
        } else if (this.collectingOutOfTurnText() && this.isOutOfTurnTag(string)) {
            this.translateButDontFlash();
            this.outofturnEntries.pop();
        } else {
            this.queueEndTag(string);
            if (this.isParagraphTag(string) && !this.collectingOutOfTurnText() && !this.collectingIntactText()) {
                this.translateAndFlush();
            }
        }
    }

    private void translateButDontFlash() throws TranslationException {
        String string;
        if (this.currEntry().size() == 0) {
            return;
        }
        String string2 = this.currEntry().sourceToShortcut();
        Element element = this.currEntry().get(0);
        if (element instanceof Tag && this.isPreformattingTag(((Tag)element).getTag())) {
            string = this.translator.translate(string2);
        } else {
            String string3 = StaticUtils.compressSpaces(string2);
            if (string3.equals(string = this.translator.translate(string3))) {
                string = string2;
            }
        }
        this.currEntry().setTranslation(string);
    }

    private void translateAndFlush() throws SAXException, TranslationException {
        this.translateButDontFlash();
        try {
            this.currWriter().write(this.currEntry().translationToOriginal());
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.currEntry().clear();
    }

    private boolean isParagraphTag(String string) {
        return this.dialect.getParagraphTags() != null && this.dialect.getParagraphTags().contains(string) || this.isPreformattingTag(string);
    }

    private boolean isPreformattingTag(String string) {
        return this.dialect.getPreformatTags() != null && this.dialect.getPreformatTags().contains(string);
    }

    private boolean isIntactTag(String string) {
        return this.dialect.getIntactTags() != null && this.dialect.getIntactTags().contains(string);
    }

    private boolean isOutOfTurnTag(String string) {
        return this.dialect.getOutOfTurnTags() != null && this.dialect.getOutOfTurnTags().contains(string);
    }

    private String getShortcut(String string) {
        if (this.dialect.getShortcuts() != null) {
            return this.dialect.getShortcuts().get(string);
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            return this.doResolve(string, string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SAXException(uRISyntaxException);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.start(string3, attributes);
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.end(string3);
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueText(new String(cArray, n, n2));
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueText(new String(cArray, n, n2));
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        this.queueComment(new String(cArray, n, n2));
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.mainWriter.write("<?xml version=\"1.0\"?>\n");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.entry = new Entry();
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.translateAndFlush();
            if (this.extWriter != null) {
                this.extWriter.close();
                this.extWriter = null;
            }
            this.translateAndFlush();
            this.currWriter().close();
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        try {
            this.reportFatalError(sAXParseException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAXException(malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SAXException(uRISyntaxException);
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.dtd = new DTD(string, string2, string3);
    }

    @Override
    public void endDTD() throws SAXException {
        this.queueDTD(this.dtd);
        this.inDTD = false;
        this.dtd = null;
    }

    @Override
    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    @Override
    public void startEntity(String string) throws SAXException {
        this.doStartEntity(string);
    }

    @Override
    public void endEntity(String string) throws SAXException {
        try {
            this.doEndEntity(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (TranslationException translationException) {
            throw new SAXException(translationException);
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.inDTD) {
            return;
        }
        Entity entity = new Entity(string, string2);
        this.internalEntities.put(string, entity);
        this.dtd.addEntity(entity);
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this.inDTD) {
            return;
        }
        try {
            Entity entity = new Entity(string, string2, this.localizeSystemId(string3));
            if (this.isInSource(string3)) {
                this.externalEntities.add(entity);
            }
            this.dtd.addEntity(entity);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SAXException(malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SAXException(uRISyntaxException);
        }
    }

    @Override
    public void elementDecl(String string, String string2) {
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
    }
}

