/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.util.OStrings;
import org.omegat.util.Token;

public class LevenshteinDistance
implements ISimilarityCalculator {
    private static final int MAX_N = 1000;
    private short[] d = new short[1001];
    private short[] p = new short[1001];

    private static short minimum(int n, int n2, int n3) {
        return (short)Math.min(n, Math.min(n2, n3));
    }

    public int compute(Token[] tokenArray, Token[] tokenArray2) {
        int n;
        if (tokenArray == null || tokenArray2 == null) {
            throw new IllegalArgumentException(OStrings.getString("LD_NULL_ARRAYS_ERROR"));
        }
        int n2 = tokenArray.length;
        int n3 = tokenArray2.length;
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n2 > 1000) {
            n2 = 1000;
        }
        if (n3 > 1000) {
            n3 = 1000;
        }
        Token token = null;
        for (n = 0; n <= n2; n = (int)((short)(n + 1))) {
            this.p[n] = n;
        }
        for (int n4 = 1; n4 <= n3; n4 = (int)((short)(n4 + 1))) {
            token = tokenArray2[n4 - 1];
            this.d[0] = n4;
            Token token2 = null;
            for (n = 1; n <= n2; n = (int)((short)(n + 1))) {
                token2 = tokenArray[n - 1];
                short s = token2.equals(token) ? (short)0 : 1;
                this.d[n] = LevenshteinDistance.minimum(this.d[n - 1] + 1, this.p[n] + 1, this.p[n - 1] + s);
            }
            short[] sArray = this.p;
            this.p = this.d;
            this.d = sArray;
        }
        return this.p[n2];
    }
}

