/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.omegat.core.data.StringEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.util.Log;

public class CoreEvents {
    private static final List<IProjectEventListener> projectEventListeners = new ArrayList<IProjectEventListener>();
    private static final List<IApplicationEventListener> applicationEventListeners = new ArrayList<IApplicationEventListener>();
    private static final List<IEntryEventListener> entryEventListeners = new ArrayList<IEntryEventListener>();
    private static final List<IFontChangedEventListener> fontChangedEventListeners = new ArrayList<IFontChangedEventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProjectChangeListener(IProjectEventListener iProjectEventListener) {
        List<IProjectEventListener> list = projectEventListeners;
        synchronized (list) {
            projectEventListeners.add(iProjectEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterProjectChangeListener(IProjectEventListener iProjectEventListener) {
        List<IProjectEventListener> list = projectEventListeners;
        synchronized (list) {
            projectEventListeners.remove(iProjectEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerApplicationEventListener(IApplicationEventListener iApplicationEventListener) {
        List<IApplicationEventListener> list = applicationEventListeners;
        synchronized (list) {
            applicationEventListeners.add(iApplicationEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterApplicationEventListener(IApplicationEventListener iApplicationEventListener) {
        List<IApplicationEventListener> list = applicationEventListeners;
        synchronized (list) {
            applicationEventListeners.remove(iApplicationEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEntryEventListener(IEntryEventListener iEntryEventListener) {
        List<IEntryEventListener> list = entryEventListeners;
        synchronized (list) {
            entryEventListeners.add(iEntryEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterEntryEventListener(IEntryEventListener iEntryEventListener) {
        List<IEntryEventListener> list = entryEventListeners;
        synchronized (list) {
            entryEventListeners.remove(iEntryEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFontChangedEventListener(IFontChangedEventListener iFontChangedEventListener) {
        List<IFontChangedEventListener> list = fontChangedEventListeners;
        synchronized (list) {
            fontChangedEventListeners.add(iFontChangedEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterFontChangedEventListener(IFontChangedEventListener iFontChangedEventListener) {
        List<IFontChangedEventListener> list = fontChangedEventListeners;
        synchronized (list) {
            fontChangedEventListeners.remove(iFontChangedEventListener);
        }
    }

    public static void fireProjectChange(final IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_PROJECT_CHANGE", new Object[]{pROJECT_CHANGE_TYPE});
                List list = projectEventListeners;
                synchronized (list) {
                    for (IProjectEventListener iProjectEventListener : projectEventListeners) {
                        iProjectEventListener.onProjectChanged(pROJECT_CHANGE_TYPE);
                    }
                }
            }
        });
    }

    public static void fireApplicationStartup() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_APPLICATION_STARTUP", new Object[0]);
                List list = applicationEventListeners;
                synchronized (list) {
                    for (IApplicationEventListener iApplicationEventListener : applicationEventListeners) {
                        iApplicationEventListener.onApplicationStartup();
                    }
                }
            }
        });
    }

    public static void fireApplicationShutdown() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_APPLICATION_SHUTDOWN", new Object[0]);
                List list = applicationEventListeners;
                synchronized (list) {
                    for (IApplicationEventListener iApplicationEventListener : applicationEventListeners) {
                        iApplicationEventListener.onApplicationShutdown();
                    }
                }
            }
        });
    }

    public static void fireEntryNewFile(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_ENTRY_NEWFILE", string);
                List list = entryEventListeners;
                synchronized (list) {
                    for (IEntryEventListener iEntryEventListener : entryEventListeners) {
                        iEntryEventListener.onNewFile(string);
                    }
                }
            }
        });
    }

    public static void fireEntryActivated(final StringEntry stringEntry) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_ENTRY_ACTIVATED", new Object[0]);
                List list = entryEventListeners;
                synchronized (list) {
                    for (IEntryEventListener iEntryEventListener : entryEventListeners) {
                        iEntryEventListener.onEntryActivated(stringEntry);
                    }
                }
            }
        });
    }

    public static void fireFontChanged(final Font font) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Log.logInfoRB("LOG_INFO_EVENT_FONT_CHANGED", new Object[0]);
                List list = fontChangedEventListeners;
                synchronized (list) {
                    for (IFontChangedEventListener iFontChangedEventListener : fontChangedEventListeners) {
                        iFontChangedEventListener.onFontChanged(font);
                    }
                }
            }
        });
    }
}

