/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.tagvalidation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.tagvalidation.ITagValidation;
import org.omegat.gui.tagvalidation.TagValidationFrame;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagValidationTool
implements ITagValidation,
IProjectEventListener {
    private TagValidationFrame m_tagWin;
    private MainWindow mainWindow;

    public TagValidationTool(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        CoreEvents.registerProjectChangeListener(this);
    }

    @Override
    public void validateTags() {
        List<SourceTextEntry> list = this.listInvalidTags();
        if (list.size() > 0) {
            if (this.m_tagWin == null) {
                this.m_tagWin = new TagValidationFrame(this.mainWindow);
                this.m_tagWin.setFont(Core.getMainWindow().getApplicationFont());
            } else {
                this.m_tagWin.dispose();
            }
            this.m_tagWin.setVisible(true);
            this.m_tagWin.displayStringList(list);
        } else {
            if (this.m_tagWin != null) {
                this.m_tagWin.dispose();
            }
            JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TF_NOTICE_OK_TAGS"), OStrings.getString("TF_NOTICE_TITLE_TAGS"), 1);
        }
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
        switch (pROJECT_CHANGE_TYPE) {
            case CLOSE: {
                if (this.m_tagWin == null) break;
                this.m_tagWin.dispose();
            }
        }
    }

    private List<SourceTextEntry> listInvalidTags() {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        ArrayList<String> arrayList2 = new ArrayList<String>(32);
        ArrayList<SourceTextEntry> arrayList3 = new ArrayList<SourceTextEntry>(16);
        Pattern pattern = PatternConsts.PRINTF_VARS;
        for (SourceTextEntry sourceTextEntry : Core.getProject().getAllEntries()) {
            Object object;
            Object object2;
            Object object3;
            StringEntry stringEntry = sourceTextEntry.getStrEntry();
            String string = stringEntry.getSrcText();
            String string2 = stringEntry.getTranslation();
            if (string2 == null || string2.length() == 0) continue;
            HashSet<String> hashSet = new HashSet<String>();
            Matcher matcher = pattern.matcher(string);
            int n = 1;
            while (matcher.find()) {
                object3 = matcher.group(0);
                object2 = matcher.group(1);
                if (object2 != null && ((String)object2).endsWith("$")) {
                    hashSet.add("" + ((String)object2).substring(0, ((String)object2).length() - 1) + ((String)object3).substring(((String)object3).length() - 1, ((String)object3).length()));
                    continue;
                }
                hashSet.add("" + n + ((String)object3).substring(((String)object3).length() - 1, ((String)object3).length()));
                ++n;
            }
            object3 = new HashSet();
            matcher = pattern.matcher(string2);
            n = 1;
            while (matcher.find()) {
                object2 = matcher.group(0);
                object = matcher.group(1);
                if (object != null && ((String)object).endsWith("$")) {
                    ((HashSet)object3).add("" + ((String)object).substring(0, ((String)object).length() - 1) + ((String)object2).substring(((String)object2).length() - 1, ((String)object2).length()));
                    continue;
                }
                ((HashSet)object3).add("" + n + ((String)object2).substring(((String)object2).length() - 1, ((String)object2).length()));
                ++n;
            }
            if (!hashSet.equals(object3)) {
                arrayList3.add(sourceTextEntry);
                continue;
            }
            object2 = string.endsWith("\n");
            object = string2.endsWith("\n");
            if (((Boolean)object2).booleanValue() && !((Boolean)object).booleanValue() || !((Boolean)object2).booleanValue() && ((Boolean)object).booleanValue()) {
                arrayList3.add(sourceTextEntry);
                continue;
            }
            StaticUtils.buildTagList(string, arrayList);
            StaticUtils.buildTagList(string2, arrayList2);
            if (arrayList.size() != arrayList2.size()) {
                arrayList3.add(sourceTextEntry);
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    string = (String)arrayList.get(i);
                    if (string.equals(string2 = (String)arrayList2.get(i))) continue;
                    arrayList3.add(sourceTextEntry);
                    break;
                }
            }
            arrayList.clear();
            arrayList2.clear();
        }
        return arrayList3;
    }
}

