/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.FloatingDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.NearString;
import org.omegat.gui.filelist.ProjectFrame;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindowMenu;
import org.omegat.gui.main.MainWindowMenuHandler;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.LFileCopy;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.WikiGet;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.ResourcesUtil;
import org.omegat.util.gui.UIThreadsUtil;

public class MainWindow
extends JFrame
implements IMainWindow {
    public final MainWindowMenu menu;
    protected ProjectFrame m_projWin;
    private Font m_font;
    private final Set<SearchWindow> m_searches = new HashSet<SearchWindow>();
    protected JLabel lengthLabel;
    protected JLabel progressLabel;
    protected JLabel statusLabel;
    protected DockingDesktop desktop;

    public MainWindow() {
        this.menu = new MainWindowMenu(this, new MainWindowMenuHandler(this));
        this.setJMenuBar(this.menu.initComponents());
        this.getContentPane().add((Component)MainWindowUI.createStatusBar(this), "South");
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainWindow.this.menu.mainWindowMenuHandler.projectExitMenuItemActionPerformed();
            }
        });
        String string = Preferences.getPreferenceDefault("source_font", "Dialog");
        int n = Preferences.getPreferenceDefault("source_font_size", 12);
        this.m_font = new Font(string, 0, n);
        MainWindowUI.createMainComponents(this, this.m_font);
        this.getContentPane().add((Component)MainWindowUI.initDocking(this), "Center");
        this.setIconImage(ResourcesUtil.getIcon("/org/omegat/gui/resources/OmegaT_small.gif").getImage());
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE pROJECT_CHANGE_TYPE) {
                MainWindow.this.updateTitle();
                if (pROJECT_CHANGE_TYPE == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                    MainWindow.this.closeSearchWindows();
                }
            }
        });
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            public void onApplicationStartup() {
                MainWindowUI.resetDesktopLayout(MainWindow.this);
                MainWindowUI.loadScreenLayout(MainWindow.this);
            }

            public void onApplicationShutdown() {
            }
        });
        this.updateTitle();
    }

    public JFrame getApplicationFrame() {
        return this;
    }

    public Font getApplicationFont() {
        return this.m_font;
    }

    protected void setApplicationFont(Font font) {
        this.m_font = font;
        Preferences.setPreference("source_font", font.getName());
        Preferences.setPreference("source_font_size", font.getSize());
        CoreEvents.fireFontChanged(font);
    }

    public void addDockable(Dockable dockable) {
        this.desktop.addDockable(dockable);
    }

    private void updateTitle() {
        String string = OStrings.getDisplayVersion();
        if (Core.getProject().isProjectLoaded()) {
            string = string + " :: " + Core.getProject().getProjectProperties().getProjectName();
        }
        this.setTitle(string);
    }

    public void doInsertTrans() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        NearString nearString = Core.getMatcher().getActiveMatch();
        if (nearString != null) {
            Core.getEditor().insertText(nearString.str.getTranslation());
        }
    }

    public void doRecycleTrans() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        NearString nearString = Core.getMatcher().getActiveMatch();
        if (nearString != null) {
            Core.getEditor().replaceEditText(nearString.str.getTranslation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSearchWindow(SearchWindow searchWindow) {
        Set<SearchWindow> set = this.m_searches;
        synchronized (set) {
            this.m_searches.add(searchWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSearchWindow(SearchWindow searchWindow) {
        Set<SearchWindow> set = this.m_searches;
        synchronized (set) {
            this.m_searches.remove(searchWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSearchWindows() {
        Set<SearchWindow> set = this.m_searches;
        synchronized (set) {
            for (SearchWindow searchWindow : this.m_searches) {
                searchWindow.dispose();
            }
            this.m_searches.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doImportSourceFiles() {
        OmegaTFileChooser omegaTFileChooser = new OmegaTFileChooser();
        omegaTFileChooser.setMultiSelectionEnabled(true);
        omegaTFileChooser.setFileSelectionMode(2);
        omegaTFileChooser.setDialogTitle(OStrings.getString("TF_FILE_IMPORT_TITLE"));
        int n = omegaTFileChooser.showOpenDialog(this);
        if (n != 0) return;
        String string = Core.getProject().getProjectProperties().getSourceRoot();
        File file = new File(string);
        File[] fileArray = omegaTFileChooser.getSelectedFiles();
        try {
            int n2 = 0;
            while (true) {
                Serializable serializable;
                if (n2 >= fileArray.length) {
                    ProjectUICommands.projectReload();
                    return;
                }
                File file2 = fileArray[n2];
                if (file2.isDirectory()) {
                    serializable = new ArrayList<String>();
                    StaticUtils.buildFileList(serializable, file2, true);
                    String string2 = file2.getParent();
                    Iterator iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        String string4 = string3.substring(string2.length());
                        File file3 = new File(string3);
                        File file4 = new File(file, string4);
                        LFileCopy.copy(file3, file4);
                    }
                } else {
                    serializable = new File(file, fileArray[n2].getName());
                    LFileCopy.copy(file2, serializable);
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            this.displayErrorRB(iOException, "MAIN_ERROR_File_Import_Failed", new Object[0]);
        }
    }

    public void doWikiImport() {
        String string = JOptionPane.showInputDialog(this, OStrings.getString("TF_WIKI_IMPORT_PROMPT"), OStrings.getString("TF_WIKI_IMPORT_TITLE"), 2);
        String string2 = Core.getProject().getProjectProperties().getSourceRoot();
        if (string != null && string.trim().length() > 0) {
            WikiGet.doWikiGet(string, string2);
            ProjectUICommands.projectReload();
        }
    }

    public void showStatusMessageRB(String string, Object ... objectArray) {
        final String string2 = string == null ? new String() + ' ' : (objectArray != null ? StaticUtils.format(OStrings.getString(string), objectArray) : OStrings.getString(string));
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                MainWindow.this.statusLabel.setText(string2);
            }
        });
    }

    public void showProgressMessage(String string) {
        this.progressLabel.setText(string);
    }

    public void showLengthMessage(String string) {
        this.lengthLabel.setText(string);
    }

    public void displayWarning(final String string, final Throwable throwable) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                MainWindow.this.statusLabel.setText(string);
                String string2 = string;
                if (throwable != null) {
                    string2 = string2 + "\n" + throwable.toString();
                }
                JOptionPane.showMessageDialog(MainWindow.this, string2, OStrings.getString("TF_WARNING"), 2);
            }
        });
    }

    public void displayErrorRB(final Throwable throwable, final String string, final Object ... objectArray) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                String string3 = objectArray != null ? StaticUtils.format(OStrings.getString(string), objectArray) : OStrings.getString(string);
                MainWindow.this.statusLabel.setText(string3);
                String string2 = string3;
                if (throwable != null) {
                    string2 = string2 + "\n" + throwable.toString();
                }
                JOptionPane.showMessageDialog(MainWindow.this, string2, OStrings.getString("TF_ERROR"), 0);
            }
        });
    }

    public void lockUI() {
        UIThreadsUtil.mustBeSwingThread();
        this.setEnabled(false);
        for (Frame frame : Frame.getFrames()) {
            frame.setEnabled(false);
        }
        block1: for (Frame frame : this.desktop.getDockables()) {
            if (frame.isDocked()) continue;
            frame.getDockable().getComponent().setEnabled(false);
            for (Container container = frame.getDockable().getComponent().getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof FloatingDialog)) continue;
                container.setEnabled(false);
                continue block1;
            }
        }
    }

    public void unlockUI() {
        UIThreadsUtil.mustBeSwingThread();
        for (DockableState dockableState : this.desktop.getDockables()) {
            if (dockableState.isDocked()) continue;
            for (Container container = dockableState.getDockable().getComponent().getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof FloatingDialog)) continue;
                container.setEnabled(true);
                break;
            }
            dockableState.getDockable().getComponent().setEnabled(true);
        }
        for (Frame frame : Frame.getFrames()) {
            frame.setEnabled(true);
        }
        this.setEnabled(true);
    }

    public void showErrorDialogRB(String string, String string2) {
        JOptionPane.showMessageDialog(this.getApplicationFrame(), OStrings.getString(string), OStrings.getString(string2), 0);
    }
}

