/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filters2;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.Filters;
import org.omegat.filters2.master.OneFilter;
import org.omegat.gui.filters2.InstanceEditor;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class FilterEditor
extends JDialog
implements ListSelectionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private Filters filters;
    private int index;
    private OneFilter filter;
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextArea descTextArea;
    private JButton editButton;
    private JLabel fileFormatLabel;
    private JTextField fileFormatTextField;
    private JTextArea hintTextArea;
    private JTable instances;
    private JScrollPane instancesScrollPane;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JButton okButton;
    private JButton removeButton;
    private JButton toDefaultsButton;
    private int returnStatus = 0;

    public FilterEditor(Dialog dialog, Filters filters, int n) {
        super(dialog, true);
        this.filter = filters.getFilter(n);
        this.filters = filters;
        this.index = n;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        this.initComponents();
        this.fileFormatTextField.setText(this.filter.getHumanName());
        if (this.filter.getHint() != null && this.filter.getHint().length() != 0) {
            this.hintTextArea.setText(this.filter.getHint());
        } else {
            this.hintTextArea.setVisible(false);
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.instances.setSelectionMode(0);
        this.instances.getSelectionModel().addListSelectionListener(this);
        TableColumn tableColumn = this.instances.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(this.encodingComboBox()));
        TableColumn tableColumn2 = this.instances.getColumnModel().getColumn(2);
        tableColumn2.setCellEditor(new DefaultCellEditor(this.encodingComboBox()));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = this.instancesScrollPane.getPreferredSize().width + 200;
        if (n2 > dimension.width) {
            n2 = dimension.width - this.addButton.getWidth() - 50;
        }
        this.instancesScrollPane.setPreferredSize(new Dimension(n2, this.instances.getPreferredSize().height + 70));
        this.pack();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private JComboBox encodingComboBox() {
        return new JComboBox<String>(new Vector<String>(FilterMaster.getSupportedEncodings()));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.toDefaultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.fileFormatLabel = new JLabel();
        this.fileFormatTextField = new JTextField();
        this.descTextArea = new JTextArea();
        this.jPanel3 = new JPanel();
        this.instancesScrollPane = new JScrollPane();
        this.instances = new JTable();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.addButton = new JButton();
        this.hintTextArea = new JTextArea();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(OStrings.getString("FILTEREDITOR_Edit_a_single_file_filter"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FilterEditor.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.toDefaultsButton, (String)OStrings.getString("BUTTON_TO_DEFAULTS"));
        this.toDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.toDefaultsButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.toDefaultsButton);
        this.jLabel1.setPreferredSize(new Dimension(20, 0));
        this.buttonPanel.add(this.jLabel1);
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.fileFormatLabel, (String)OStrings.getString("FILTEREDITOR_File_Format"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.fileFormatLabel, gridBagConstraints);
        this.fileFormatTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.fileFormatTextField, gridBagConstraints);
        this.descTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.descTextArea.setEditable(false);
        this.descTextArea.setFont(new JLabel().getFont());
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(OStrings.getString("FILTEREDITOR_DESC"));
        this.descTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.descTextArea, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.instances.setModel(this.filter);
        this.instancesScrollPane.setViewportView(this.instances);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.instancesScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)OStrings.getString("BUTTON_REMOVE"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)OStrings.getString("BUTTON_EDIT"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)OStrings.getString("BUTTON_ADD"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.hintTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.hintTextArea.setEditable(false);
        this.hintTextArea.setFont(new JLabel().getFont());
        this.hintTextArea.setLineWrap(true);
        this.hintTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.hintTextArea, gridBagConstraints);
        this.pack();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.instances.getSelectedRow();
        Instance instance = this.filter.getInstance(n);
        if (0 == JOptionPane.showConfirmDialog(this, StaticUtils.format(OStrings.getString("FILTEREDITOR_really_delete_filter_instance"), instance.getSourceFilenameMask()), OStrings.getString("FILTEREDITOR_Confirm_deletion_TITLE"), 0, 3)) {
            this.filter.removeInstance(n);
        }
    }

    private void toDefaultsButtonActionPerformed(ActionEvent actionEvent) {
        try {
            Class<?> clazz = Class.forName(this.filter.getClassName());
            boolean bl = this.filter.isFromPlugin();
            Constructor<?> constructor = clazz.getConstructor(null);
            AbstractFilter abstractFilter = (AbstractFilter)constructor.newInstance(null);
            this.filter = new OneFilter(abstractFilter, bl);
            this.filters.setFilter(this.index, this.filter);
            this.instances.setModel(this.filter);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, OStrings.getString("FILTEREDITOR_ERROR_Reverting_To_Def") + exception, OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        InstanceEditor instanceEditor = new InstanceEditor((Dialog)this, this.filter.isSourceEncodingVariable(), this.filter.isTargetEncodingVariable(), this.filter.getHint());
        instanceEditor.setVisible(true);
        if (instanceEditor.getReturnStatus() == 1) {
            this.filter.addInstance(new Instance(instanceEditor.getSourceFilenameMask(), instanceEditor.getSourceEncoding(), instanceEditor.getTargetEncoding(), instanceEditor.getTargetFilenamePattern()));
        }
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.instances.getSelectedRow();
        InstanceEditor instanceEditor = new InstanceEditor(this, this.filter.isSourceEncodingVariable(), this.filter.isTargetEncodingVariable(), this.filter.getHint(), this.instances.getModel().getValueAt(n, 0).toString(), this.instances.getModel().getValueAt(n, 1).toString(), this.instances.getModel().getValueAt(n, 2).toString(), this.instances.getModel().getValueAt(n, 3).toString());
        instanceEditor.setVisible(true);
        if (instanceEditor.getReturnStatus() == 1) {
            this.filter.setInstance(n, new Instance(instanceEditor.getSourceFilenameMask(), instanceEditor.getSourceEncoding(), instanceEditor.getTargetEncoding(), instanceEditor.getTargetFilenamePattern()));
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

