/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.LanguageComboBoxRenderer;
import org.omegat.util.gui.OmegaTFileChooser;
import org.openide.awt.Mnemonics;

public class ProjectPropertiesDialog
extends JDialog {
    private ProjectProperties projectProperties;
    public static final int NEW_PROJECT = 1;
    public static final int RESOLVE_DIRS = 2;
    public static final int EDIT_PROJECT = 3;
    private int dialogType;
    private boolean m_dialogCancelled;

    public ProjectPropertiesDialog(ProjectProperties projectProperties, String string, int n) {
        super((Frame)Core.getMainWindow().getApplicationFrame(), true);
        Serializable serializable;
        this.projectProperties = projectProperties;
        this.dialogType = n;
        EmptyBorder emptyBorder = new EmptyBorder(2, 0, 2, 0);
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        jTextArea.setFont(new Label().getFont());
        Box box2 = Box.createHorizontalBox();
        box2.setBorder(emptyBorder);
        box2.add(jTextArea);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        Box box3 = Box.createVerticalBox();
        box3.setBorder(new EtchedBorder());
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)OStrings.getString("PP_SRC_LANG"));
        Box box4 = Box.createHorizontalBox();
        box4.setBorder(emptyBorder);
        box4.add(jLabel);
        box4.add(Box.createHorizontalGlue());
        box3.add(box4);
        final JComboBox<Language> jComboBox = new JComboBox<Language>(Language.LANGUAGES);
        if (jComboBox.getMaximumRowCount() < 20) {
            jComboBox.setMaximumRowCount(20);
        }
        jComboBox.setEditable(true);
        jComboBox.setRenderer(new LanguageComboBoxRenderer());
        jComboBox.setSelectedItem(projectProperties.getSourceLanguage());
        box3.add(jComboBox);
        JLabel jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)OStrings.getString("PP_LOC_LANG"));
        Box box5 = Box.createHorizontalBox();
        box5.setBorder(emptyBorder);
        box5.add(jLabel2);
        box5.add(Box.createHorizontalGlue());
        box3.add(box5);
        final JComboBox<Language> jComboBox2 = new JComboBox<Language>(Language.LANGUAGES);
        if (jComboBox2.getMaximumRowCount() < 20) {
            jComboBox2.setMaximumRowCount(20);
        }
        jComboBox2.setEditable(true);
        jComboBox2.setRenderer(new LanguageComboBoxRenderer());
        jComboBox2.setSelectedItem(projectProperties.getTargetLanguage());
        box3.add(jComboBox2);
        final JCheckBox jCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)jCheckBox, (String)OStrings.getString("PP_SENTENCE_SEGMENTING"));
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)OStrings.getString("MW_OPTIONSMENU_SENTSEG"));
        Box box6 = Box.createHorizontalBox();
        box6.add(jCheckBox);
        box6.add(Box.createHorizontalGlue());
        box6.add(jButton);
        box3.add(box6);
        box.add(box3);
        box.add(Box.createVerticalStrut(5));
        Box box7 = Box.createVerticalBox();
        box7.setBorder(new EtchedBorder());
        JLabel jLabel3 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)OStrings.getString("PP_SRC_ROOT"));
        Box box8 = Box.createHorizontalBox();
        box8.setBorder(emptyBorder);
        box8.add(jLabel3);
        box8.add(Box.createHorizontalGlue());
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)OStrings.getString("PP_BUTTON_BROWSE_SRC"));
        box8.add(jButton2);
        final JTextField jTextField = new JTextField();
        box7.add(box8);
        box7.add(jTextField);
        JLabel jLabel4 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)OStrings.getString("PP_TM_ROOT"));
        Box box9 = Box.createHorizontalBox();
        box9.setBorder(emptyBorder);
        box9.add(jLabel4);
        box9.add(Box.createHorizontalGlue());
        JButton jButton3 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)OStrings.getString("PP_BUTTON_BROWSE_TM"));
        box9.add(jButton3);
        final JTextField jTextField2 = new JTextField();
        box7.add(box9);
        box7.add(jTextField2);
        JLabel jLabel5 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel5, (String)OStrings.getString("PP_GLOS_ROOT"));
        Box box10 = Box.createHorizontalBox();
        box10.setBorder(emptyBorder);
        box10.add(jLabel5);
        box10.add(Box.createHorizontalGlue());
        JButton jButton4 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton4, (String)OStrings.getString("PP_BUTTON_BROWSE_GL"));
        box10.add(jButton4);
        final JTextField jTextField3 = new JTextField();
        box7.add(box10);
        box7.add(jTextField3);
        JLabel jLabel6 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel6, (String)OStrings.getString("PP_LOC_ROOT"));
        Box box11 = Box.createHorizontalBox();
        box11.setBorder(emptyBorder);
        box11.add(jLabel6);
        box11.add(Box.createHorizontalGlue());
        JButton jButton5 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton5, (String)OStrings.getString("PP_BUTTON_BROWSE_TAR"));
        box11.add(jButton5);
        final JTextField jTextField4 = new JTextField();
        box7.add(box11);
        box7.add(jTextField4);
        box.add(box7);
        this.getContentPane().add((Component)box, "Center");
        JButton jButton6 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton6, (String)OStrings.getString("BUTTON_OK"));
        JButton jButton7 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton7, (String)OStrings.getString("BUTTON_CANCEL"));
        Box box12 = Box.createHorizontalBox();
        box12.setBorder(new EmptyBorder(5, 5, 5, 5));
        box12.add(Box.createHorizontalGlue());
        box12.add(jButton6);
        box12.add(Box.createHorizontalStrut(5));
        box12.add(jButton7);
        this.getContentPane().add((Component)box12, "South");
        this.setResizable(false);
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPropertiesDialog.this.doOK(jComboBox, jComboBox2, jCheckBox, jTextField, jTextField4, jTextField3, jTextField2);
            }
        });
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPropertiesDialog.this.doCancel();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(1, jTextField);
            }
        });
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(2, jTextField4);
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(3, jTextField3);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(4, jTextField2);
            }
        });
        final ProjectPropertiesDialog projectPropertiesDialog = this;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new SegmentationCustomizer(projectPropertiesDialog).setVisible(true);
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPropertiesDialog.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        jTextField.setText(projectProperties.getSourceRoot());
        jTextField4.setText(projectProperties.getTargetRoot());
        jTextField3.setText(projectProperties.getGlossaryRoot());
        jTextField2.setText(projectProperties.getTMRoot());
        jComboBox.setSelectedItem(projectProperties.getSourceLanguage());
        jComboBox2.setSelectedItem(projectProperties.getTargetLanguage());
        jCheckBox.setSelected(projectProperties.isSentenceSegmentingEnabled());
        switch (this.dialogType) {
            case 2: {
                jComboBox.setEnabled(false);
                jComboBox2.setEnabled(false);
                jCheckBox.setEnabled(false);
                serializable = new File(jTextField.getText());
                if (!((File)serializable).exists() || !((File)serializable).isDirectory()) {
                    jTextField.setForeground(Color.RED);
                }
                if (!((File)(serializable = new File(jTextField4.getText()))).exists() || !((File)serializable).isDirectory()) {
                    jTextField4.setForeground(Color.RED);
                }
                if (!((File)(serializable = new File(jTextField3.getText()))).exists() || !((File)serializable).isDirectory()) {
                    jTextField3.setForeground(Color.RED);
                }
                if (((File)(serializable = new File(jTextField2.getText()))).exists() && ((File)serializable).isDirectory()) break;
                jTextField2.setForeground(Color.RED);
            }
        }
        this.updateUIText(jTextArea);
        this.pack();
        this.setSize(9 * this.getWidth() / 8, this.getHeight() + 10);
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension = this.getSize();
        this.setLocation((((Dimension)serializable).width - dimension.width) / 2, (((Dimension)serializable).height - dimension.height) / 2);
    }

    private void doBrowseDirectoy(int n, JTextField jTextField) {
        int n2;
        File file;
        String string;
        switch (n) {
            case 1: {
                string = OStrings.getString("PP_BROWSE_TITLE_SOURCE");
                break;
            }
            case 2: {
                string = OStrings.getString("PP_BROWSE_TITLE_TARGET");
                break;
            }
            case 3: {
                string = OStrings.getString("PP_BROWSE_TITLE_GLOS");
                break;
            }
            case 4: {
                string = OStrings.getString("PP_BROWSE_TITLE_TM");
                break;
            }
            default: {
                return;
            }
        }
        OmegaTFileChooser omegaTFileChooser = new OmegaTFileChooser();
        omegaTFileChooser.setDialogTitle(string);
        omegaTFileChooser.setFileSelectionMode(1);
        String string2 = jTextField != null ? jTextField.getText() : "";
        File file2 = new File(string2);
        if (!file2.exists() || !file2.isDirectory()) {
            string2 = this.projectProperties.getProjectRoot();
            file2 = new File(string2);
        }
        if (!file2.exists() || !file2.isDirectory()) {
            switch (n) {
                case 1: {
                    string2 = Preferences.getPreference("source_folder");
                    break;
                }
                case 2: {
                    string2 = Preferences.getPreference("target_folder");
                    break;
                }
                case 3: {
                    string2 = Preferences.getPreference("glossary_folder");
                    break;
                }
                case 4: {
                    string2 = Preferences.getPreference("tm_folder");
                }
            }
        }
        if (string2.equals("")) {
            string2 = Preferences.getPreference("current_folder");
        }
        if (!string2.equals("") && (file = new File(string2)).exists() && file.isDirectory()) {
            omegaTFileChooser.setCurrentDirectory(file);
        }
        if ((n2 = omegaTFileChooser.showOpenDialog(this)) != 0) {
            return;
        }
        File file3 = omegaTFileChooser.getSelectedFile();
        if (file3 == null) {
            return;
        }
        String string3 = file3.getAbsolutePath() + File.separator;
        switch (n) {
            case 1: {
                Preferences.setPreference("source_folder", omegaTFileChooser.getSelectedFile().getParent());
                this.projectProperties.setSourceRoot(string3);
                jTextField.setText(this.projectProperties.getSourceRoot());
                if (!new File(this.projectProperties.getSourceRoot()).exists() || !new File(this.projectProperties.getSourceRoot()).isDirectory()) break;
                jTextField.setForeground(SystemColor.textText);
                break;
            }
            case 2: {
                Preferences.setPreference("target_folder", omegaTFileChooser.getSelectedFile().getParent());
                this.projectProperties.setTargetRoot(string3);
                jTextField.setText(this.projectProperties.getTargetRoot());
                if (!new File(this.projectProperties.getTargetRoot()).exists() || !new File(this.projectProperties.getTargetRoot()).isDirectory()) break;
                jTextField.setForeground(SystemColor.textText);
                break;
            }
            case 3: {
                Preferences.setPreference("glossary_folder", omegaTFileChooser.getSelectedFile().getParent());
                this.projectProperties.setGlossaryRoot(string3);
                jTextField.setText(this.projectProperties.getGlossaryRoot());
                if (!new File(this.projectProperties.getGlossaryRoot()).exists() || !new File(this.projectProperties.getGlossaryRoot()).isDirectory()) break;
                jTextField.setForeground(SystemColor.textText);
                break;
            }
            case 4: {
                Preferences.setPreference("tm_folder", omegaTFileChooser.getSelectedFile().getParent());
                this.projectProperties.setTMRoot(string3);
                jTextField.setText(this.projectProperties.getTMRoot());
                if (!new File(this.projectProperties.getTMRoot()).exists() || !new File(this.projectProperties.getTMRoot()).isDirectory()) break;
                jTextField.setForeground(SystemColor.textText);
            }
        }
    }

    private void doOK(JComboBox jComboBox, JComboBox jComboBox2, JCheckBox jCheckBox, JTextField jTextField, JTextField jTextField2, JTextField jTextField3, JTextField jTextField4) {
        if (!ProjectProperties.verifySingleLangCode(jComboBox.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_INVALID_SOURCE_LOCALE") + OStrings.getString("NP_LOCALE_SUGGESTION"), OStrings.getString("TF_ERROR"), 0);
            jComboBox.requestFocusInWindow();
            return;
        }
        this.projectProperties.setSourceLanguage(jComboBox.getSelectedItem().toString());
        if (!ProjectProperties.verifySingleLangCode(jComboBox2.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_INVALID_TARGET_LOCALE") + OStrings.getString("NP_LOCALE_SUGGESTION"), OStrings.getString("TF_ERROR"), 0);
            jComboBox2.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTargetLanguage(jComboBox2.getSelectedItem().toString());
        this.projectProperties.setSentenceSegmentingEnabled(jCheckBox.isSelected());
        this.projectProperties.setSourceRoot(jTextField.getText());
        if (!this.projectProperties.getSourceRoot().endsWith(File.separator)) {
            this.projectProperties.setSourceRoot(this.projectProperties.getSourceRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getSourceRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_SOURCEDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            jTextField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTargetRoot(jTextField2.getText());
        if (!this.projectProperties.getTargetRoot().endsWith(File.separator)) {
            this.projectProperties.setTargetRoot(this.projectProperties.getTargetRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getTargetRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_TRANSDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            jTextField2.requestFocusInWindow();
            return;
        }
        this.projectProperties.setGlossaryRoot(jTextField3.getText());
        if (!this.projectProperties.getGlossaryRoot().endsWith(File.separator)) {
            this.projectProperties.setGlossaryRoot(this.projectProperties.getGlossaryRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getGlossaryRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_GLOSSDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            jTextField3.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTMRoot(jTextField4.getText());
        if (!this.projectProperties.getTMRoot().endsWith(File.separator)) {
            this.projectProperties.setTMRoot(this.projectProperties.getTMRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getTMRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_TMDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            jTextField4.requestFocusInWindow();
            return;
        }
        this.m_dialogCancelled = false;
        this.setVisible(false);
    }

    private void doCancel() {
        if (this.dialogType == 1) {
            new File(this.projectProperties.getProjectRoot()).delete();
        }
        this.m_dialogCancelled = true;
        this.setVisible(false);
    }

    private void updateUIText(JTextArea jTextArea) {
        switch (this.dialogType) {
            case 1: {
                this.setTitle(OStrings.getString("PP_CREATE_PROJ"));
                jTextArea.setText(OStrings.getString("PP_MESSAGE_CONFIGPROJ"));
                break;
            }
            case 2: {
                this.setTitle(OStrings.getString("PP_OPEN_PROJ"));
                jTextArea.setText(OStrings.getString("PP_MESSAGE_BADPROJ"));
                break;
            }
            case 3: {
                this.setTitle(OStrings.getString("PP_EDIT_PROJECT"));
                jTextArea.setText(OStrings.getString("PP_MESSAGE_EDITPROJ"));
            }
        }
    }

    public ProjectProperties getResult() {
        return this.m_dialogCancelled ? null : this.projectProperties;
    }
}

