/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;

import blanco.html.parser.valueobject.BlancoHtmlAttribute;

/**
 * HTMLRec̃CxgVACY܂B
 * 
 * ̃RecEnh[pƁAdg݂ƂăRec̃CxgƂHTML낤Ƃ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoHtmlContentSerializer implements BlancoHtmlContentHandler {
    protected BufferedWriter fWriter;

    /**
     * vf̊JñN[YyfBOꂽ܂܂ǂB
     */
    protected boolean fIsStartElementClosePending = false;

    public BufferedWriter getWriter() {
        return fWriter;
    }

    public void setWriter(final BufferedWriter writer) {
        fWriter = writer;
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        flushElementClosePending();
    }

    /**
     * Gg̊JnB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     * @param attributes
     * @throws IOException
     */
    public void startElement(final String name,
            final List<BlancoHtmlAttribute> attrs) throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        // JAB
        flushElementClosePending();

        fWriter.write('<');
        fWriter.write(name);

        for (BlancoHtmlAttribute attr : attrs) {
            fWriter.write(' ');
            fWriter.write(attr.getName());

            if (attr.getValue() != null) {
                fWriter.write('=');

                // TODO NI[g̏dɗO𔭐邱ƁB
                
                switch (attr.getQuote()) {
                case 0:
                    break;
                case 1:
                    fWriter.write('\'');
                    break;
                case 2:
                default:
                    fWriter.write('"');
                    break;
                }

                fWriter.write(attr.getValue());

                switch (attr.getQuote()) {
                case 0:
                    break;
                case 1:
                    fWriter.write('\'');
                    break;
                case 2:
                default:
                    fWriter.write('"');
                    break;
                }
            } else {
                // l̖B
            }
        }

        fIsStartElementClosePending = true;
    }

    /**
     * Gg̏IB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     * @throws IOException
     */
    public void endElement(final String name) throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        if (fIsStartElementClosePending) {
            // ȃN[YB
            fIsStartElementClosePending = false;
            fWriter.write("/>");
        } else {
            fWriter.write("</");
            fWriter.write(name);
            fWriter.write('>');
        }
    }

    /**
     * B̎QƂȂǂ̏ĂȂ񂪁û܂܁v߂܂B
     * 
     * @param argCharacters
     * @throws IOException
     */
    public void characters(final String argCharacters) throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        flushElementClosePending();

        fWriter.write(argCharacters);
    }

    /**
     * RgB̂܂܂̕񂪖߂܂B
     * 
     * @param argComments
     * @param argType
     * @throws IOException
     */
    public void comments(final String argComments, final int argType)
            throws IOException {
        if (fWriter == null) {
            throw new IllegalArgumentException("܂O: C^[nullłB");
        }

        flushElementClosePending();

        switch (argType) {
        case 0:
        default:
            fWriter.write("<!--");
            break;
        case 1:
            fWriter.write("<%--");
            break;
        }

        fWriter.write(argComments);

        switch (argType) {
        case 0:
        default:
            fWriter.write("-->");
            break;
        case 1:
            fWriter.write("-->");
            break;
        }
    }

    /**
     * J̗vf΁A܂B
     * 
     * @throws IOException
     */
    protected void flushElementClosePending() throws IOException {
        if (fIsStartElementClosePending) {
            fIsStartElementClosePending = false;
            fWriter.write('>');
        }
    }
}
