/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.html.parser;

import java.io.IOException;
import java.util.List;

import blanco.html.parser.valueobject.BlancoHtmlAttribute;

/**
 * HTML  SAX ̂悤Ƀp[XRecEnh[B
 * 
 * @author IGA Tosiki
 */
public interface BlancoHtmlContentHandler {
    /**
     * hLg̊JnB
     * 
     * @throws IOException
     */
    public void startDocument() throws IOException;

    /**
     * hLg̏IB
     * 
     * @throws IOException
     */
    public void endDocument() throws IOException;

    /**
     * vf̊JnB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     * @param attributes
     *            ̃XgB
     */
    public void startElement(final String name,
            final List<BlancoHtmlAttribute> attrs) throws IOException;

    /**
     * vf̏IB
     * 
     * HTMLƂ̂߁Astart  end ƂK΂ɔ܂B
     * 
     * @param name
     *            vfB
     */
    public void endElement(final String name) throws IOException;

    /**
     * B̎QƂȂǂ̏ĂȂ񂪁û܂܁v߂܂B
     * 
     * @param argCharacters
     */
    public void characters(final String argCharacters) throws IOException;

    /**
     * RgB̂܂܂̕񂪖߂܂B
     * 
     * @param argComments
     * @param argType
     *            0:!A1:%
     */
    public void comments(final String argComments, final int argType)
            throws IOException;
}
