/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.calc.parser.block;

import java.util.ArrayList;
import java.util.List;

/**
 * JԂ^̃ubN܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCalcParserTableBlock extends AbstractBlancoCalcParserBlock {
    private List<BlancoCalcParserTableColumn> list = new ArrayList<BlancoCalcParserTableColumn>();

    private String blockRowName = "";

    /**
     * ^CgT[`ۂɁA^Cg̍siʏ͂Psj ̐񋟂܂B
     */
    private int waitForIteratorTitleSearchY = 1;

    /**
     * JԂ^̃ubNIuWFNg̃RXgN^łB
     * 
     * @param name
     *            ubNB
     */
    public BlancoCalcParserTableBlock(String name) {
        setName(name);
    }

    /**
     * JԂ^̃ubNIuWFNgɃJǉ܂B
     * 
     * @param item
     *            ubNւƒǉJB
     */
    public void add(BlancoCalcParserTableColumn item) {
        list.add(item);
    }

    /**
     * ^CgsɁAACe܂B
     * 
     * @param titleString
     *            ^CgB
     * @return ꂽACeB
     */
    public BlancoCalcParserTableColumn findByTitleString(String titleString) {
        final int listSize = list.size();
        for (int index = 0; index < listSize; index++) {
            final BlancoCalcParserTableColumn item = (BlancoCalcParserTableColumn) list
                    .get(index);
            if (item.isStartString(titleString)) {
                return item;
            }
        }
        return null;
    }

    /**
     * ԍɁAACe܂B
     * 
     * @param pos
     *            ̔ԍB
     * @return ꂽACeB
     */
    public BlancoCalcParserTableColumn findByColumnPosition(int pos) {
        final int listSize = list.size();
        for (int index = 0; index < listSize; index++) {
            final BlancoCalcParserTableColumn item = (BlancoCalcParserTableColumn) list
                    .get(index);
            if (item.getColumnPosition() == pos) {
                return item;
            }
        }
        return null;
    }

    /**
     * x͈̌͂擾܂B
     * 
     * @return x͈̌́B
     */
    public int getSearchRangeForTitleY() {
        return waitForIteratorTitleSearchY;
    }

    /**
     * ^Cg񂩂̂w͈̌͂擾܂B
     * 
     * @param arg
     *            w͈̌́B
     */
    public void setSearchRangeForTitleY(int arg) {
        waitForIteratorTitleSearchY = arg;
    }

    /**
     * ̖Oݒ肵܂B
     * 
     * @param arg
     *            ̖OB
     */
    public void setRowName(String arg) {
        blockRowName = arg;
    }

    /**
     * ̖O擾܂B
     * 
     * @return ̖OB
     */
    public String getRowName() {
        return blockRowName;
    }
}
