/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ant.util;

import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlComment;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * Apache Antbuild.xml𐶐邽߂̃[eBeBNXłB
 * 
 * @author IGA Tosiki
 */
public class BlancoAntUtil {
    /**
     * GgɃAgr[gǉ܂B
     * 
     * @param element
     * @param name
     * @param value
     */
    public static void addAttribute(final BlancoXmlElement element,
            final String name, final String value) {
        final BlancoXmlAttribute attr = new BlancoXmlAttribute();
        element.getAtts().add(attr);
        attr.setLocalName(name);
        attr.setValue(value);
    }

    /**
     * sǉ܂B
     * 
     * @param element
     */
    public static void addNewLine(final BlancoXmlElement element) {
        final BlancoXmlCharacters characters = new BlancoXmlCharacters();
        element.getChildNodes().add(characters);
        characters.setValue("\n");
    }

    /**
     * Cfg^uǉ܂B
     * 
     * @param element
     */
    public static void addIndentTab(final BlancoXmlElement element) {
        final BlancoXmlCharacters characters = new BlancoXmlCharacters();
        element.getChildNodes().add(characters);
        characters.setValue("\t");
    }

    /**
     * vpeB^Oǉ܂B
     * 
     * @param element
     * @param name
     * @param value
     */
    public static void addProperty(final BlancoXmlElement element,
            final String name, final String value) {
        final BlancoXmlElement elementChild = new BlancoXmlElement();
        element.getChildNodes().add(elementChild);
        elementChild.setLocalName("property");

        addAttribute(elementChild, "name", name);
        addAttribute(elementChild, "value", value);

        addNewLine(element);
    }

    /**
     * Rgǉ܂B
     * 
     * @param element
     * @param argComment
     */
    public static void addComment(final BlancoXmlElement element,
            final String argComment) {
        final BlancoXmlComment comment = new BlancoXmlComment();
        element.getChildNodes().add(comment);
        comment.setValue(" " + argComment + " ");

        addNewLine(element);
    }

    /**
     * echo^Oǉ܂B
     * 
     * @param element
     * @param argEchoString
     */
    public static void addEcho(final BlancoXmlElement element,
            final String argEchoString) {
        final BlancoXmlElement elementEcho = new BlancoXmlElement();
        element.getChildNodes().add(elementEcho);
        elementEcho.setLocalName("echo");

        final BlancoXmlCharacters characters = new BlancoXmlCharacters();
        elementEcho.getChildNodes().add(characters);
        characters.setValue(argEchoString);

        addNewLine(element);
    }

    /**
     * OAnt^XNǉ܂B
     * 
     * @param element
     * @param taskName
     * @param className
     * @param targetDirs
     */
    public static void addTaskExternal(final BlancoXmlElement element,
            final String taskName, final String className,
            final String[] targetDirs) {
        addIndentTab(element);

        final BlancoXmlElement elementTaskDef = new BlancoXmlElement();
        element.getChildNodes().add(elementTaskDef);
        elementTaskDef.setLocalName("taskdef");

        addAttribute(elementTaskDef, "name", taskName);
        addAttribute(elementTaskDef, "classname", className);

        final BlancoXmlElement elementClasspath = new BlancoXmlElement();
        elementTaskDef.getChildNodes().add(elementClasspath);
        elementClasspath.setLocalName("classpath");

        if (targetDirs != null) {
            for (int index = 0; index < targetDirs.length; index++) {
                final BlancoXmlElement elementFileset = new BlancoXmlElement();
                elementClasspath.getChildNodes().add(elementFileset);
                elementFileset.setLocalName("fileset");

                addAttribute(elementFileset, "dir", targetDirs[index]);
                addAttribute(elementFileset, "includes", "*.jar");
            }
        }

        addNewLine(element);
        addNewLine(element);
    }
}
