/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg;

import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgException;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgLangDocTag;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.cg.valueobject.BlancoCgReturn;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.cg.valueobject.BlancoCgType;

/**
 * blancoCg̃o[IuWFNg쐬邽߂̃t@NgNXłB
 * 
 * ̃NX̓vO~O𒴂ėp܂B<br>
 * blancoCg̃o[IuWFNǵÃt@NgNXoRĐ邱Ƃ܂B <br>
 * Ƃ͂ʂɃo[IuWFNg𐶐邱Ƃ͋֎~Ă܂B
 * 
 * ̃NX finalƂ܂Bp҂̃NXpĊg邱Ƃz肵܂B
 * 
 * ȑO createLine Ƃ\bh܂Ap~܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCgObjectFactory {

    /**
     * IuWFNgt@Ng̃RXgN^B
     * 
     * privateāAt@NgʂĂVK쐬łȂ悤ɂĂ܂B
     */
    private BlancoCgObjectFactory() {
    }

    /**
     * BlancoCgIuWFNgt@Ng̃CX^X擾܂B
     * 
     * @return BlancoCgIuWFNgt@Ng̃CX^XB
     */
    public static BlancoCgObjectFactory getInstance() {
        return new BlancoCgObjectFactory();
    }

    /**
     * \[Xt@CCX^X𐶐܂B
     * 
     * t@C͖IɎw肵ĂȂƂ_ɒӂČĂяoĂB<br>
     * \[Xt@C̓NX瓱o܂B
     * 
     * @param argPackageName
     *            pbP[WB̃pbP[W玩̃fBNg\肳܂B
     * @param argDescription
     *            \[Xt@C̐B
     * @return \[Xt@CCX^XB
     */
    public BlancoCgSourceFile createSourceFile(final String argPackageName,
            final String argDescription) {
        final BlancoCgSourceFile cgSourceFile = new BlancoCgSourceFile();
        cgSourceFile.setPackage(argPackageName);
        cgSourceFile.setDescription(argDescription);

        // hLg̃CX^XftHgŐ܂B
        cgSourceFile.setLangDoc(new BlancoCgLangDoc());

        return cgSourceFile;
    }

    /**
     * ^CX^X𐶐܂B
     * 
     * ztOWFlNXwɂẮÃIuWFNgɃZbgĂB
     * 
     * @param argTypeName
     *            ^BpbP[W܂񂾃NXEC^tF[Xw肷_ɒӂĂB
     * @return ^CX^XB
     */
    public BlancoCgType createType(final String argTypeName) {
        final BlancoCgType cgType = new BlancoCgType();
        cgType.setName(getTypeNameWithoutGenerics(argTypeName));

        // DescriptionɂẮAt@Ng̐ɂ̓Zbg܂B

        // WFlNX΂ɂ́Ai[
        cgType.setGenerics(getGenericsFromFullName(argTypeName));

        return cgType;
    }

    /**
     * NXCX^X𐶐܂B
     * 
     * @param argClassName
     *            NXBpbP[WNXw肷_ɒӂĂBpbP[W̓\[Xt@CCX^XQƂœo܂
     *            B
     * @param argDescription
     *            NX̐B
     * @return NXCX^XB
     */
    public BlancoCgClass createClass(final String argClassName,
            final String argDescription) {
        final BlancoCgClass cgClass = new BlancoCgClass();
        cgClass.setName(argClassName);
        cgClass.setDescription(argDescription);

        // hLg̃CX^XftHgŐ܂B
        cgClass.setLangDoc(new BlancoCgLangDoc());

        return cgClass;
    }

    /**
     * C^tF[XCX^X𐶐܂B
     * 
     * @param argInterfaceName
     *            C^tF[XBpbP[WC^tF[Xw肷_ɒӂĂB
     *            pbP[W̓\[Xt@CCX^XQƂœo܂B
     * @param argDescription
     *            C^tF[X̐B
     * @return C^tF[XCX^XB
     */
    public BlancoCgInterface createInterface(final String argInterfaceName,
            final String argDescription) {
        final BlancoCgInterface cgInterface = new BlancoCgInterface();
        cgInterface.setName(argInterfaceName);
        cgInterface.setDescription(argDescription);

        // hLg̃CX^XftHgŐ܂B
        cgInterface.setLangDoc(new BlancoCgLangDoc());

        return cgInterface;
    }

    /**
     * tB[hCX^X𐶐܂B
     * 
     * @param argName
     *            tB[h̕ϐB
     * @param argTypeNameWithPackage
     *            pbP[Wť^B
     * @param argDescription
     *            tB[h̐B
     * @return tB[hCX^XB
     */
    public BlancoCgField createField(final String argName,
            final String argTypeNameWithPackage, final String argDescription) {
        final BlancoCgField cgField = new BlancoCgField();
        cgField.setName(argName);
        cgField.setDescription(argDescription);

        // hLg̃CX^XftHgŐ܂B
        cgField.setLangDoc(new BlancoCgLangDoc());

        // ^IuWFNg쐬āAZbg܂B
        cgField.setType(createType(argTypeNameWithPackage));

        return cgField;
    }

    /**
     * \bhCX^X𐶐܂B
     * 
     * @param methodName
     *            \bhB
     * @param argDescription
     *            \bh̐B
     * @return \bhCX^XB
     */
    public BlancoCgMethod createMethod(final String methodName,
            final String argDescription) {
        final BlancoCgMethod cgMethod = new BlancoCgMethod();
        cgMethod.setName(methodName);
        cgMethod.setDescription(argDescription);

        // hLg̃CX^XftHgŐ܂B
        cgMethod.setLangDoc(new BlancoCgLangDoc());

        return cgMethod;
    }

    /**
     * p[^CX^X𐶐܂B
     * 
     * @param argName
     *            p[^̈B
     * @param argFullTypeName
     *            t^B
     * @param argDescription
     *            B
     * @return p[^CX^XB
     */
    public BlancoCgParameter createParameter(final String argName,
            final String argFullTypeName, final String argDescription) {
        return createParameter(argName, argFullTypeName, argDescription, false);
    }

    /**
     * p[^CX^X𐶐܂B
     * 
     * @param argName
     *            p[^̈B
     * @param argFullTypeName
     *            t^B
     * @param argDescription
     *            B
     * @param argNotNull
     *            null񂪕t^邩ǂB
     * @return p[^CX^XB
     */
    public BlancoCgParameter createParameter(final String argName,
            final String argFullTypeName, final String argDescription,
            final boolean argNotNull) {
        final BlancoCgParameter cgParameter = new BlancoCgParameter();
        cgParameter.setName(argName);
        cgParameter.setDescription(argDescription);
        cgParameter.setNotnull(argNotNull);

        // hLg̃CX^X́Ap[^CX^Xɂ݂͑܂B

        // ^IuWFNg쐬āAZbg܂B
        cgParameter.setType(createType(argFullTypeName));

        return cgParameter;
    }

    /**
     * ReturnCX^X𐶐܂B
     * 
     * @param argFullTypeName
     *            t^B
     * @param argDescription
     *            ߂l̐B
     * @return ReturnCX^XB
     */
    public BlancoCgReturn createReturn(final String argFullTypeName,
            final String argDescription) {
        final BlancoCgReturn cgReturn = new BlancoCgReturn();
        cgReturn.setDescription(argDescription);

        // hLg̃CX^X́AReturnCX^Xɂ݂͑܂B

        // ^IuWFNg쐬āAZbg܂B
        cgReturn.setType(createType(argFullTypeName));

        return cgReturn;
    }

    /**
     * OCX^X𐶐܂B
     * 
     * @param argFullTypeName
     *            t^B
     * @param argDescription
     *            B
     * @return OCX^XB
     */
    public BlancoCgException createException(final String argFullTypeName,
            final String argDescription) {
        final BlancoCgException cgException = new BlancoCgException();
        cgException.setDescription(argDescription);

        // hLg̃CX^X́AOCX^Xɂ݂͑܂B

        // ^IuWFNg쐬āAZbg܂B
        cgException.setType(createType(argFullTypeName));

        return cgException;
    }

    /**
     * hLg̃^O𐶐܂B
     * 
     * @param argName
     *            ^O̖OB
     * @param argKey
     *            ^ÕL[Bw肵ꍇɂnull^܂B
     * @param argValue
     *            ^O̒lB
     * @return sCX^XB
     */
    public BlancoCgLangDocTag createLangDocTag(final String argName,
            final String argKey, final String argValue) {
        final BlancoCgLangDocTag cgTag = new BlancoCgLangDocTag();
        cgTag.setName(argName);
        cgTag.setKey(argKey);
        cgTag.setValue(argValue);

        return cgTag;
    }

    private String getTypeNameWithoutGenerics(final String argFullType) {
        int find = argFullType.indexOf('<');
        if (find > 0) {
            return argFullType.substring(0, find);
        }
        return argFullType;
    }

    private String getGenericsFromFullName(final String argFullType) {
        int find = argFullType.indexOf('<');
        if (find > 0) {
            return argFullType.substring(find);
        }
        return null;
    }

}