/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import jp.sourceforge.mergedoc.pleiades.log.SystemOutLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Logger {
    public static final String LOGGER_CLASS_NAME = "pleiades.logger.class.name";
    public static final String LOG_LEVEL = "pleiades.log.level";
    private static volatile Level minLevel;
    private final String className;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(Class<?> clazz) {
        Class<Logger> clazz2 = Logger.class;
        synchronized (Logger.class) {
            if (minLevel == null) {
                String logLevel = System.getProperty(LOG_LEVEL, Level.INFO.toString());
                try {
                    minLevel = Level.valueOf(logLevel.toUpperCase());
                }
                catch (IllegalStateException e) {
                    throw new IllegalStateException("\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3 pleiades.log.level=" + logLevel + " \u306b\u6307\u5b9a\u3059\u308b\u5024\u306f " + Level.class.getName() + "\u3067\u5b9a\u7fa9\u3055\u308c\u305f\u578b\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
                }
                System.out.println("pleiades.log.level=" + logLevel);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String loggerClassName = System.getProperty(LOGGER_CLASS_NAME, SystemOutLogger.class.getName());
            try {
                Constructor<?> cons = Class.forName(loggerClassName).getDeclaredConstructor(Class.class);
                cons.setAccessible(true);
                return (Logger)cons.newInstance(clazz);
            }
            catch (Exception e) {
                throw new IllegalStateException("\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3 pleiades.logger.class.name=" + loggerClassName + " \u306b\u6307\u5b9a\u3055\u308c\u305f\u30ed\u30ac\u30fc\u30af\u30e9\u30b9\u304c\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
            }
        }
    }

    protected Logger(Class<?> clazz) {
        this.className = clazz.getName().replaceFirst("(\\w+\\.)+", "");
    }

    protected abstract PrintStream getOut();

    protected void println(Level level, String message, Throwable t) {
        Date date = new Date();
        String threadName = Thread.currentThread().getName();
        String s = String.format("%-5s %tT.%tL [%s] (%s) %s", new Object[]{level, date, date, threadName, this.className, message});
        PrintStream out = this.getOut();
        out.println(s);
        if (t != null) {
            t.printStackTrace(out);
        }
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable e) {
        if (this.isDebugEnabled()) {
            this.println(Level.DEBUG, message, e);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable e) {
        if (this.isInfoEnabled()) {
            this.println(Level.INFO, message, e);
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable e) {
        if (this.isWarnEnabled()) {
            this.println(Level.WARN, message, e);
        }
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable e) {
        if (this.isErrorEnabled()) {
            this.println(Level.ERROR, message, e);
        }
    }

    public void fatal(String message) {
        this.fatal(message, null);
    }

    public void fatal(String message, Throwable e) {
        if (this.isFatalEnabled()) {
            this.println(Level.FATAL, message, e);
        }
    }

    public boolean isDebugEnabled() {
        return minLevel == Level.DEBUG;
    }

    public boolean isInfoEnabled() {
        return minLevel == Level.DEBUG || minLevel == Level.INFO;
    }

    public boolean isWarnEnabled() {
        return minLevel == Level.DEBUG || minLevel == Level.INFO || minLevel == Level.WARN;
    }

    public boolean isErrorEnabled() {
        return minLevel == Level.DEBUG || minLevel == Level.INFO || minLevel == Level.WARN || minLevel == Level.ERROR;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

