/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformer
implements ClassFileTransformer {
    private static final Logger log = Logger.getLogger(AbstractTransformer.class);
    private Set<String> relatedClassPathSet = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transform(ClassLoader loader, String internalName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytecode) throws IllegalClassFormatException {
        if (loader == null || internalName.startsWith("java/") || internalName.startsWith("javax/") || internalName.startsWith("sun/") || internalName.startsWith("com/sun/") || internalName.startsWith("org/apache/commons") || internalName.startsWith("jp/sourceforge/mergedoc/pleiades/")) {
            return null;
        }
        try {
            URL location;
            if (protectionDomain != null && (location = protectionDomain.getCodeSource().getLocation()) != null) {
                String locationPath = location.getPath();
                if (locationPath.contains("org.apache.jasper_")) {
                    return null;
                }
                if (locationPath.contains("org.eclipse.osgi_") || locationPath.contains("org.eclipse.core.resources_") || locationPath.contains("org.eclipse.ui.workbench_") || locationPath.contains("org.eclipse.jface_") || locationPath.contains("org.eclipse.jdt.core_") || locationPath.contains("org.eclipse.jdt.ui_") || locationPath.contains("org.eclipse.dltk.core_") || locationPath.contains("org.eclipse.swt.") || locationPath.contains("mergedoc.jstyle.swt")) {
                    String classPath = Files.decodePath(locationPath);
                    AbstractTransformer abstractTransformer = this;
                    synchronized (abstractTransformer) {
                        this.relatedClassPathSet.add(classPath);
                    }
                }
            }
            String className = internalName.replace('/', '.');
            return this.transform(loader, className, protectionDomain, bytecode);
        }
        catch (Throwable e) {
            String msg = "\u30d0\u30a4\u30c8\u30b3\u30fc\u30c9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + internalName;
            log.error(msg, e);
            throw new IllegalClassFormatException(String.valueOf(msg) + " \u539f\u56e0:" + e);
        }
    }

    protected abstract byte[] transform(ClassLoader var1, String var2, ProtectionDomain var3, byte[] var4) throws CannotCompileException, NotFoundException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CtClass createCtClass(byte[] bytecode, ProtectionDomain protectionDomain) throws IOException, NotFoundException {
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        AbstractTransformer abstractTransformer = this;
        synchronized (abstractTransformer) {
            for (String relatedClassPath : this.relatedClassPathSet) {
                classPool.appendClassPath(relatedClassPath);
            }
        }
        return classPool.makeClass((InputStream)new ByteArrayInputStream(bytecode));
    }

    protected void logDescriptor(CtClass ctClass) {
        CtBehavior[] ctBehaviorArray = ctClass.getDeclaredBehaviors();
        int n = ctBehaviorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CtBehavior behavior = ctBehaviorArray[n2];
            log.info("DESCRIPTOR: " + ctClass.getName() + "#" + behavior.getName() + " " + behavior.getMethodInfo().getDescriptor());
            ++n2;
        }
    }
}

