import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.omegat.core.StringEntry;
import org.omegat.core.matching.FuzzyMatcherWrapper;
import org.omegat.core.matching.NearString;

public class Test extends TestCase {

    public void testTest() {

        FuzzyMatcherWrapper fuzzyMatcher = FuzzyMatcherWrapper.getInstance();
        List tuStrings = new ArrayList();
        List tmStrings = new ArrayList();

        StringEntry tuEntry = new StringEntry("This is source text.");
        tuStrings.add(tuEntry);

        {
            StringEntry tmEntry = new StringEntry("This is target text.");
            tmEntry.setTranslation("̓^[QbgEeLXgłB");
            tmStrings.add(tmEntry);
        }

        {
            StringEntry tmEntry = new StringEntry("This is source text.");
            tmEntry.setTranslation("̓\[XEeLXgłB");
            tmStrings.add(tmEntry);
        }

        fuzzyMatcher.match(tuStrings, tmStrings, "testTmx");

        System.out.println(tuEntry.getNearListTranslated().size()
                + "̃}b`݂܂B");
        for (int i = 0; i < tuEntry.getNearListTranslated().size(); i++) {
            NearString nearString = (NearString) tuEntry
                    .getNearListTranslated().get(i);
            System.out.println("------------------------------------");
            System.out.println((i + 1) + "");
            System.out.println(nearString.score + "%}b`");
            System.out.println(nearString.str.getTranslation());
        }
        System.out.println("------------------------------------");
        System.out.println("");
    }

    public void test2Test() {
        // eXgs
        testTest();
    }

}
