import java.io.File;

import junit.framework.TestCase;

import org.omegat.core.StringEntry;
import org.omegat.core.glossary.GlossaryEntry;

import blanco.omegat.util.glossary.MyGlossaryManager;

public class GlossaryTest extends TestCase {
    public void test() throws Exception {
        final MyGlossaryManager gm = new MyGlossaryManager();
        gm.loadGlossaryFiles(new File("glossary"));

        final StringEntry tuEntry = new StringEntry("This is source text.");

        gm.getGlossary(tuEntry);

        System.out.println(tuEntry.getGlossaryEntries().size()
                + "̗pꂪ݂܂B");
        for (int i = 0; i < tuEntry.getGlossaryEntries().size(); i++) {
            GlossaryEntry glossaryEntry = (GlossaryEntry) tuEntry
                    .getGlossaryEntries().get(i);
            System.out.println("------------------------------------");
            System.out.println((i + 1) + "");
            System.out.println(glossaryEntry.getSrcText());
            System.out.println(glossaryEntry.getLocText());
            System.out.println(glossaryEntry.getCommentText());
        }
        System.out.println("------------------------------------");
        System.out.println("");
    }
}
