import java.io.File;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.omegat.core.StringEntry;
import org.omegat.core.matching.FuzzyMatcherWrapper;
import org.omegat.core.matching.NearString;
import org.omegat.util.Language;
import org.omegat.util.TMXReader;

import blanco.omegat.util.matching.OmegaTWrapper;

public class TmxTest extends TestCase {
    public void test() throws Exception {
        OmegaTWrapper.getCommandThread();

        final TMXReader reader = new TMXReader("UTF-8", new Language("en-US"),
                new Language("ja-JP"));

        final File dirTmx = new File(
                "../blancoXliff2Tmx/tmp/tmx/org.eclipse-SDK_3.4");
        final File[] fileTmxs = dirTmx.listFiles();
        if (fileTmxs == null) {
            return;
        }
        for (int index = 0; index < fileTmxs.length; index++) {
            final File fileTmx = fileTmxs[index];
            if (fileTmx.isFile() == false) {
                continue;
            }

            reader.loadFile(fileTmx.getAbsolutePath(), true);
        }

        final int num = reader.numSegments();
        final ArrayList strEntryList = new ArrayList(num);

        for (int i = 0; i < num; i++) {
            String src = reader.getSourceSegment(i);
            String trans = reader.getTargetSegment(i);

            StringEntry se = new StringEntry(src);
            se.setTranslation(trans);
            strEntryList.add(se);
        }

        final FuzzyMatcherWrapper fuzzyMatcher = FuzzyMatcherWrapper
                .getInstance();
        final List tuStrings = new ArrayList();

        final StringEntry tuEntry = new StringEntry(
                "Choose the file system.");
        tuStrings.add(tuEntry);

        fuzzyMatcher.match(tuStrings, strEntryList, "testTmx");

        if (tuEntry.getNearListTranslated().size() > 0) {
            System.out.println(tuEntry.getNearListTranslated().size()
                    + "̃}b`݂܂B");
            System.out.println("()" + tuEntry.getSrcText());
            for (int i = 0; i < tuEntry.getNearListTranslated().size(); i++) {
                NearString nearString = (NearString) tuEntry
                        .getNearListTranslated().get(i);
                System.out.println("------------------------------------");
                System.out.println((i + 1) + "");
                System.out.println(nearString.score + "%}b`");
                System.out.println(nearString.str.getSrcText());
                System.out.println(nearString.str.getTranslation());
            }
            System.out.println("------------------------------------");
            System.out.println("");
        }
    }
}
