/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.awt.GraphicsEnvironment;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.PatternConsts;
import org.omegat.util.Token;
import org.omegat.util.WordIterator;

public class StaticUtils {
    private static final String WINDOWS_CONFIG_DIR = "\\OmegaT\\";
    private static final String UNIX_CONFIG_DIR = "/.omegat/";
    private static final String OSX_CONFIG_DIR = "/Library/Preferences/OmegaT/";
    private static String m_configDir = null;
    private static BreakIterator wordBreaker = null;
    private static Map tokenCache = new Hashtable();
    private static final String CVS_SVN_FOLDERS = "(CVS)|(.svn)|(_svn)";
    private static final Pattern IGNORED_FOLDERS = Pattern.compile("(CVS)|(.svn)|(_svn)");
    private static String INSTALLDIR = null;

    public static void buildTagList(String string, ArrayList arrayList) {
        String string2 = "";
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                string2 = "";
                n = 2;
                continue;
            }
            if (c == '>') {
                if (PatternConsts.OMEGAT_TAG_ONLY.matcher(string2).matches()) {
                    arrayList.add(string2);
                }
                n = 1;
                string2 = "";
                continue;
            }
            if (n != 2) continue;
            string2 = string2 + c;
        }
    }

    public static void buildFileList(ArrayList arrayList, File file, boolean bl) {
        int n;
        File[] fileArray = null;
        try {
            fileArray = file.listFiles();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileArray == null) {
            return;
        }
        for (n = 0; n < Array.getLength(fileArray); ++n) {
            if (fileArray[n].isDirectory()) continue;
            arrayList.add(fileArray[n].getAbsolutePath());
        }
        if (bl) {
            for (n = 0; n < Array.getLength(fileArray); ++n) {
                if (!StaticUtils.isProperDirectory(fileArray[n])) continue;
                StaticUtils.buildFileList(arrayList, fileArray[n], true);
            }
        }
    }

    public static void buildDirList(ArrayList arrayList, File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < Array.getLength(fileArray); ++i) {
            if (!StaticUtils.isProperDirectory(fileArray[i])) continue;
            arrayList.add(fileArray[i].getAbsolutePath());
            StaticUtils.buildDirList(arrayList, fileArray[i]);
        }
    }

    public static BreakIterator getWordBreaker() {
        return new WordIterator();
    }

    public static void clearTokenCache() {
        tokenCache.clear();
    }

    public static List tokenizeText(String string) {
        return StaticUtils.tokenizeText(string, false);
    }

    public static List tokenizeText(String string, boolean bl) {
        List<Token> list = null;
        if (!bl && (list = (List)tokenCache.get(string)) != null) {
            return list;
        }
        list = new ArrayList();
        if (!bl) {
            tokenCache.put(string, list);
        }
        if (string.length() == 0) {
            return list;
        }
        string = string.toLowerCase();
        BreakIterator breakIterator = StaticUtils.getWordBreaker();
        breakIterator.setText(string);
        int n = breakIterator.first();
        int n2 = breakIterator.next();
        while (n2 != -1) {
            String string2 = string.substring(n, n2);
            boolean bl2 = false;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (!Character.isLetter(c)) continue;
                bl2 = true;
                break;
            }
            if (bl || bl2 && !PatternConsts.OMEGAT_TAG.matcher(string2).matches()) {
                Token token = new Token(string2, n);
                list.add(token);
            }
            n = n2;
            n2 = breakIterator.next();
        }
        return list;
    }

    public static String[] getFontNames() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getAvailableFontFamilyNames();
    }

    public static boolean isSubset(List list, List list2) {
        for (int i = 0; i < list.size(); ++i) {
            if (list2.contains(list.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isProperDirectory(File file) {
        if (file.isDirectory()) {
            Matcher matcher = IGNORED_FOLDERS.matcher(file.getName());
            return !matcher.matches();
        }
        return false;
    }

    public static String makeValidXML(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '>': {
                return "&gt;";
            }
            case '<': {
                return "&lt;";
            }
            case '\"': {
                return "&quot;";
            }
        }
        return String.valueOf(c);
    }

    public static String makeValidXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = StaticUtils.fixChars(string);
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            stringBuffer.append(StaticUtils.makeValidXML(c));
        }
        return stringBuffer.toString();
    }

    public static String compressSpaces(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl2 = Character.isWhitespace(c);
            if (bl2) {
                if (bl) continue;
                bl = true;
                continue;
            }
            if (bl && stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(c);
            bl = false;
        }
        return stringBuffer.toString();
    }

    private static String classPathElement(String string, int n) {
        int n2 = string.lastIndexOf(File.pathSeparatorChar, n);
        int n3 = string.indexOf(File.pathSeparatorChar, n);
        if (n2 < 0) {
            n2 = -1;
        }
        if (n3 < 0) {
            n3 = string.length();
        }
        return string.substring(n2 + 1, n3);
    }

    private static String tryThisClasspathElement(String string, String string2) {
        try {
            int n = string.indexOf(string2);
            if (n >= 0) {
                String string3 = StaticUtils.classPathElement(string, n);
                string3 = string3.substring(0, string3.indexOf(string2));
                return string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String installDir() {
        if (INSTALLDIR != null) {
            return INSTALLDIR;
        }
        String string = System.getProperty("java.class.path");
        String string2 = StaticUtils.tryThisClasspathElement(string, "OmegaT.jar");
        if (string2 == null) {
            string2 = StaticUtils.tryThisClasspathElement(string, OConsts.DEBUG_CLASSPATH);
        }
        if (string2 == null) {
            string2 = ".";
        }
        INSTALLDIR = string2 = new File(string2).getAbsolutePath();
        return string2;
    }

    public static String getConfigDir() {
        File file;
        String string;
        String string2;
        String string3;
        if (m_configDir != null) {
            return m_configDir;
        }
        try {
            string3 = System.getProperty("os.name");
            string2 = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            m_configDir = new File(".").getAbsolutePath();
            Log.logErrorRB("SU_USERHOME_PROP_ACCESS_ERROR");
            Log.log(securityException.toString());
            return m_configDir;
        }
        if (string3 == null || string3.length() == 0 || string2 == null || string2.length() == 0) {
            m_configDir = new File(".").getAbsolutePath();
            return m_configDir;
        }
        m_configDir = string3.startsWith("Windows") ? ((string = (file = new File(string2, "Application Data")).exists() ? file.getAbsolutePath() : null) != null && string.length() > 0 ? string + WINDOWS_CONFIG_DIR : string2) : (string3.equals("Linux") || string3.equals("Solaris") || string3.equals("FreeBSD") ? string2 + UNIX_CONFIG_DIR : (string3.equals("Mac OS X") ? string2 + OSX_CONFIG_DIR : string2));
        if (m_configDir.length() > 0) {
            try {
                boolean bl;
                file = new File(m_configDir);
                if (!file.exists() && !(bl = file.mkdirs())) {
                    Log.logErrorRB("SU_CONFIG_DIR_CREATE_ERROR");
                    m_configDir = new File(".").getAbsolutePath();
                }
            }
            catch (SecurityException securityException) {
                m_configDir = new File(".").getAbsolutePath();
                Log.logErrorRB("SU_CONFIG_DIR_CREATE_ERROR");
                Log.log(securityException.toString());
            }
        }
        return m_configDir;
    }

    public static boolean onMacOSX() {
        String string;
        try {
            string = System.getProperty("os.name");
        }
        catch (SecurityException securityException) {
            return false;
        }
        return string.equals("Mac OS X");
    }

    public static String stripTags(String string) {
        return PatternConsts.OMEGAT_TAG.matcher(string).replaceAll("");
    }

    public static boolean equal(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public static String uuencode(byte[] byArray) {
        if (byArray.length <= 0) {
            return new String();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[0]);
        for (int i = 1; i < byArray.length; ++i) {
            stringBuffer.append('#');
            stringBuffer.append(byArray[i]);
        }
        return stringBuffer.toString();
    }

    public static byte[] uudecode(String string) {
        String[] stringArray = string.split("#");
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                byArray[i] = Byte.parseByte(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                byArray[i] = 0;
            }
        }
        return byArray;
    }

    public static String makeFilenameRelative(String string, String string2) {
        if (string.toLowerCase().startsWith(string2.toLowerCase())) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String escapeNonRegex(String string) {
        return StaticUtils.escapeNonRegex(string, true);
    }

    public static String escapeNonRegex(String string, boolean bl) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        String string2 = "^.+[]{}()&|-:=!<>";
        for (int i = 0; i < string2.length(); ++i) {
            string = string.replaceAll("\\" + string2.charAt(i), "\\\\" + string2.charAt(i));
        }
        if (bl) {
            string = string.replaceAll("\\?", "\\\\?");
            string = string.replaceAll("\\*", "\\\\*");
        } else {
            string = string.replaceAll("\\?", "\\\\S?");
            string = string.replaceAll("\\*", "\\\\S*");
        }
        return string;
    }

    public static String format(String string, Object[] objectArray) {
        string = string.replaceAll("'", "''");
        return MessageFormat.format(string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadFileToString(String string) throws IOException {
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        URL uRL = new URL(string);
        uRLConnection = uRL.openConnection();
        inputStream = uRLConnection.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            LFileCopy.copy(inputStream, (OutputStream)byteArrayOutputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void downloadFileToDisk(String string, String string2) throws MalformedURLException {
        block15: {
            int n;
            URLConnection uRLConnection = null;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            StringBuffer stringBuffer = new StringBuffer();
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            outputStream = new BufferedOutputStream(new FileOutputStream(string2));
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            Object var10_10 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                break block15;
            }
            catch (IOException iOException) {}
            break block15;
            {
                catch (IOException iOException) {
                    Log.logErrorRB("IO exception");
                    Log.log(iOException);
                    Object var10_11 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void extractFileFromJar(String string, ArrayList arrayList, String string2) throws IOException {
        JarFile jarFile = new JarFile(string);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (!arrayList.contains(jarEntry.getName())) continue;
            File file = new File(string2 + File.separator + jarEntry.getName());
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            bufferedOutputStream.close();
        }
    }

    public static String ltrim(String string) {
        return string.replaceAll("^\\s+", "");
    }

    public static String rtrim(String string) {
        return string.replaceAll("\\s+$", "");
    }

    public static String fixChars(String string) {
        char[] cArray = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n < 32) {
                if (n != 9 && n != 10 && n != 13) {
                    n = 32;
                }
            } else if (!(n >= 32 && n <= 55295 || n >= 57344 && n <= 65533 || n >= 65536 && n <= 0x10FFFF)) {
                n = 32;
            }
            cArray[i] = n;
        }
        return new String(cArray);
    }
}

