/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class Log {
    private static final String FILE_LOG = "log.txt";
    private static PrintWriter log = Log.getLogWriter();

    public static String getLogLocation() {
        return StaticUtils.getConfigDir() + FILE_LOG;
    }

    public static PrintWriter getLogWriter() {
        SessionPrintStream sessionPrintStream = null;
        if (log == null) {
            try {
                sessionPrintStream = new SessionPrintStream(new PrintStream(new FileOutputStream(StaticUtils.getConfigDir() + FILE_LOG, true)));
                log = new PrintWriter(new OutputStreamWriter((OutputStream)sessionPrintStream, "UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            SessionPrintStream sessionPrintStream2 = new SessionPrintStream(System.out);
            System.setOut(sessionPrintStream2);
            if (log != null) {
                sessionPrintStream2.setSessionID(sessionPrintStream.getSessionID());
            }
        }
        return log;
    }

    public static void log(String string) {
        try {
            log.println(string);
            log.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(string);
        System.out.flush();
    }

    public static void logRB(String string) {
        Log.logRB(string, null);
    }

    public static void logRB(String string, Object[] objectArray) {
        String string2 = OStrings.getString(string);
        if (objectArray != null) {
            string2 = StaticUtils.format(string2, objectArray);
        }
        Log.log(string2);
    }

    public static void log(Throwable throwable) {
        Log.log(throwable.getClass().getName() + ":");
        String string = throwable.getMessage();
        if (string != null && string.length() > 0) {
            Log.log(string);
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Log.log(stringWriter.toString());
    }

    public static void logWarningRB(String string) {
        String string2 = OStrings.getString(string);
        Log.logWarning(string, string2, null);
    }

    public static void logWarningRB(String string, Object[] objectArray) {
        String string2 = OStrings.getString(string);
        Log.logWarning(string, string2, objectArray);
    }

    public static void logWarning(String string, String string2) {
        Log.logWarning(string, string2, null);
    }

    public static void logWarning(String string, String string2, Object[] objectArray) {
        Log.logIdentifiableMessage(StaticUtils.format(OStrings.getString("LOG_WARNING_ID"), new Object[]{string}), string2, objectArray);
    }

    public static void logErrorRB(String string) {
        String string2 = OStrings.getString(string);
        Log.logError(string, string2, null);
    }

    public static void logErrorRB(String string, Object[] objectArray) {
        String string2 = OStrings.getString(string);
        Log.logError(string, string2, objectArray);
    }

    public static void logError(String string, String string2) {
        Log.logError(string, string2, null);
    }

    public static void logError(String string, String string2, Object[] objectArray) {
        Log.logIdentifiableMessage(StaticUtils.format(OStrings.getString("LOG_ERROR_ID"), new Object[]{string}), string2, objectArray);
    }

    protected static void logIdentifiableMessage(String string, String string2, Object[] objectArray) {
        Log.log(string);
        if (objectArray != null) {
            string2 = StaticUtils.format(string2, objectArray);
        }
        Log.log(string2);
    }

    private static class SessionPrintStream
    extends PrintStream {
        String sessionID;
        private boolean lastIsNewline = false;

        public SessionPrintStream(PrintStream printStream) {
            super(printStream);
            Random random = new Random();
            random.setSeed(System.currentTimeMillis());
            int n = Math.abs(random.nextInt());
            this.sessionID = String.valueOf(n);
            if (this.sessionID.length() > 5) {
                this.sessionID = this.sessionID.substring(0, 5);
            } else if (this.sessionID.length() < 5) {
                for (int i = 5; i > this.sessionID.length(); ++i) {
                    this.sessionID = "0" + this.sessionID;
                }
            }
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public void setSessionID(String string) {
            this.sessionID = string;
        }

        void printSessionID() {
            this.printSessionID(false);
        }

        void printSessionID(boolean bl) {
            if (bl || this.lastIsNewline) {
                super.print(this.sessionID + ": ");
            }
        }

        public void print(boolean bl) {
            this.print(String.valueOf(bl));
        }

        public void print(char c) {
            this.print(String.valueOf(c));
        }

        public void print(char[] cArray) {
            for (int i = 0; i < cArray.length; ++i) {
                this.print(cArray[i]);
            }
        }

        public void print(double d) {
            this.print(String.valueOf(d));
        }

        public void print(float f) {
            this.print(String.valueOf(f));
        }

        public void print(int n) {
            this.print(String.valueOf(n));
        }

        public void print(long l) {
            this.print(String.valueOf(l));
        }

        public void print(Object object) {
            this.print(String.valueOf(object));
        }

        public void print(String string) {
            if (string == null) {
                string = "null";
            }
            byte[] byArray = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                this.write(byArray[i]);
            }
        }

        public void println() {
            this.printSessionID();
            super.println();
            this.lastIsNewline = true;
        }

        public void println(boolean bl) {
            this.print(bl);
            this.println();
        }

        public void println(char c) {
            this.print(c);
            this.println();
        }

        public void println(char[] cArray) {
            this.print(cArray);
            this.println();
        }

        public void println(double d) {
            this.print(d);
            this.println();
        }

        public void println(float f) {
            this.print(f);
            this.println();
        }

        public void println(int n) {
            this.print(n);
            this.println();
        }

        public void println(long l) {
            this.print(l);
            this.println();
        }

        public void println(Object object) {
            this.print(object);
            this.println();
        }

        public void println(String string) {
            this.print(string);
            this.println();
        }

        public void write(int n) {
            this.printSessionID();
            super.write(n);
            this.lastIsNewline = (char)n == '\n';
        }
    }
}

