/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.util.ArrayList;

public class SegmentHistory {
    private static SegmentHistory INSTANCE;
    private int pointer = -1;
    private ArrayList history = new ArrayList();

    protected SegmentHistory() {
    }

    public static SegmentHistory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SegmentHistory();
        }
        return INSTANCE;
    }

    public boolean hasNext() {
        return this.pointer > -1 && this.pointer < this.history.size() - 1;
    }

    public boolean hasPrev() {
        return this.pointer > 0;
    }

    public void insertNew(int n) {
        if (this.pointer > -1) {
            int n2 = (Integer)this.history.get(this.pointer);
            if (n2 == n) {
                return;
            }
            if (this.pointer < this.history.size() - 1) {
                for (int i = this.history.size() - 1; i > this.pointer; --i) {
                    this.history.remove(i);
                }
            }
        }
        this.history.add(new Integer(n));
        ++this.pointer;
    }

    public int getValue() {
        if (this.pointer > -1) {
            return this.get(this.pointer);
        }
        return -1;
    }

    public int back() {
        if (this.pointer < 0) {
            return -1;
        }
        if (this.pointer > 0) {
            --this.pointer;
        }
        int n = this.get(this.pointer);
        return n;
    }

    public int forward() {
        if (this.pointer == -1 || this.pointer >= this.history.size() - 1) {
            return -1;
        }
        return this.get(++this.pointer);
    }

    private int get(int n) {
        return (Integer)this.history.get(n);
    }

    public void clear() {
        this.history.clear();
        this.pointer = -1;
    }
}

