/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.SourceTextEntry;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Token;
import org.omegat.util.gui.Styles;

public class MatchesTextArea
extends JTextPane
implements MouseListener {
    private List matches;
    private List delimiters;
    private int activeMatch;
    private StringBuffer displayBuffer;
    private MainWindow mw;

    public MatchesTextArea(MainWindow mainWindow) {
        this.mw = mainWindow;
        this.setEditable(false);
        this.setMinimumSize(new Dimension(100, 50));
        this.addMouseListener(this);
    }

    public void setMatches(List list) {
        this.matches = list;
        this.activeMatch = -1;
        this.delimiters = new ArrayList(list.size() + 1);
        this.delimiters.add(new Integer(0));
        this.displayBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            NearString nearString = (NearString)list.get(i);
            this.displayBuffer.append(i + 1 + ") " + nearString.str.getSrcText() + "\n" + nearString.str.getTranslation() + "\n< " + nearString.score + "% " + nearString.proj + " >");
            if (i < list.size() - 1) {
                this.displayBuffer.append("\n\n");
            }
            this.delimiters.add(new Integer(this.displayBuffer.length()));
        }
        this.setText(this.displayBuffer.toString());
        this.setActiveMatch(0);
    }

    public void setActiveMatch(int n) {
        int n2;
        if (n < 0 || n >= this.matches.size() || this.activeMatch == n) {
            return;
        }
        this.activeMatch = n;
        this.selectAll();
        this.setCharacterAttributes(Styles.PLAIN, true);
        int n3 = (Integer)this.delimiters.get(n);
        int n4 = (Integer)this.delimiters.get(n + 1);
        NearString nearString = (NearString)this.matches.get(n);
        List list = nearString.str.getSrcTokenListAll();
        byte[] byArray = nearString.attr;
        for (n2 = 0; n2 < list.size(); ++n2) {
            Token token = (Token)list.get(n2);
            int n5 = n3 + 3 + token.getOffset();
            int n6 = n3 + 3 + token.getOffset() + token.getLength();
            this.select(n5, n6);
            if ((byArray[n2] & 1) != 0) {
                this.setCharacterAttributes(Styles.TEXT_EXTRA, false);
                continue;
            }
            if ((byArray[n2] & 2) == 0) continue;
            this.setCharacterAttributes(Styles.TEXT_BORDER, false);
        }
        this.select(n3, n4);
        this.setCharacterAttributes(Styles.BOLD, false);
        this.setCaretPosition(n4 - 2);
        n2 = n3;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MatchesTextArea.this.setCaretPosition(n2);
            }
        });
    }

    public void clear() {
        this.matches = null;
        this.setText(new String());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.matches == null || this.matches.size() == 0) {
            return;
        }
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
            int n;
            int n2 = -1;
            int n3 = this.viewToModel(mouseEvent.getPoint());
            for (int i = 0; i < this.delimiters.size() - 1; ++i) {
                n = (Integer)this.delimiters.get(i);
                int n4 = (Integer)this.delimiters.get(i + 1);
                if (n3 < n || n3 >= n4) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                n2 = this.delimiters.size() - 1;
            }
            n = n2;
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = jPopupMenu.add(OStrings.getString("MATCHES_INSERT"));
            jMenuItem.addActionListener(new ActionListener(){

                public synchronized void actionPerformed(ActionEvent actionEvent) {
                    MatchesTextArea.this.setActiveMatch(n);
                    MatchesTextArea.this.mw.doInsertTrans();
                }
            });
            jMenuItem = jPopupMenu.add(OStrings.getString("MATCHES_REPLACE"));
            jMenuItem.addActionListener(new ActionListener(){

                public synchronized void actionPerformed(ActionEvent actionEvent) {
                    MatchesTextArea.this.setActiveMatch(n);
                    MatchesTextArea.this.mw.doRecycleTrans();
                }
            });
            jPopupMenu.addSeparator();
            if (n >= this.matches.size()) {
                return;
            }
            final NearString nearString = (NearString)this.matches.get(n);
            String string = nearString.proj;
            jMenuItem = jPopupMenu.add(OStrings.getString("MATCHES_GO_TO_SEGMENT_SOURCE"));
            if (string == null || string.equals("")) {
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        MatchesTextArea.this.mw.doGotoEntry(((SourceTextEntry)nearString.str.getParentList().first()).entryNum() + 1);
                    }
                });
            } else {
                jMenuItem.setEnabled(false);
            }
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public int getActiveMatch() {
        return this.activeMatch;
    }
}

